% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibtex.R
\name{bibtex}
\alias{bibtex}
\alias{packageReferenceFile}
\alias{package_bibliography}
\title{Bibtex Utilities}
\usage{
packageReferenceFile(PACKAGE = NULL, check = FALSE)

package_bibliography(PACKAGE = NULL, action = c("path", "copy", "load"))
}
\arguments{
\item{PACKAGE}{package name. If \code{NULL}, then the name of the calling package is used.}

\item{check}{logical that indicates if the result should be an empty string if the
bibliography file (or package) does not exist.}

\item{action}{single character string that specifies the action to be performed:
\itemize{
\item 'path': return the path to the bibliography file. It returns an empty character
string if the file does not exist.
\item 'copy': copy the bibliography file to the current directory, overwriting any existing
\code{REFERENCES.bib} file.
\item 'load': load the bibliography file and return a list of \link[utils:bibentry]{utils::bibentry}
objects. It returns \code{NULL} if the file does not exist.
}}
}
\description{
Utility functions to work with BiBTeX files.
}
\section{Functions}{
\itemize{
\item \code{packageReferenceFile}: returns the path to a package REFERENCES.bib file.

\item \code{package_bibliography}: returns the bibliography associated with a package.
This can
}}

\examples{
\dontshow{
options(R_CHECK_RUNNING_EXAMPLES_=TRUE) ## roxygen generated flag
}


packageReferenceFile('pkgmaker')
packageReferenceFile('pkgmaker', check = TRUE)

}
