% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-news.R
\name{build_news}
\alias{build_news}
\title{Build news section}
\usage{
build_news(pkg = ".", override = list(), preview = NA)
}
\arguments{
\item{pkg}{Path to package.}

\item{override}{An optional named list used to temporarily override
values in \code{_pkgdown.yml}}

\item{preview}{If \code{TRUE}, or \code{is.na(preview) && interactive()}, will preview
freshly generated section in browser.}
}
\description{
Your \code{NEWS.md} is parsed in to sections based on your use of headings.
}
\details{
The \code{NEWS.md} file should be formatted with level one headings (\code{#})
containing the package name and version number, level two headings (\code{##})
with topic headings and lists of news bullets. Commonly used level two
headings include 'Major changes', 'Bug fixes', or 'Minor changes'.\preformatted{# pkgdown 0.1.0.9000

## Major changes

- Fresh approach based on the staticdocs package. Site configuration now based
  on YAML files.
}

If the package is available on CRAN, release dates will be added to versions
in level-one headings, and "Unreleased" will be added versions that are not on
CRAN.

Issues and contributors mentioned in news items are automatically linked to
github if a \code{URL} entry linking to github.com is provided in the package
\code{DESCRIPTION}.\preformatted{## Major changes

- Lots of bug fixes (@hadley, #100)
}
}
\section{YAML config}{


To automatically link to release announcements, include a \code{releases}
section.\preformatted{news:
 releases:
 - text: "usethis 1.3.0"
   href: https://www.tidyverse.org/articles/2018/02/usethis-1-3-0/
 - text: "usethis 1.0.0 (and 1.1.0)"
   href: https://www.tidyverse.org/articles/2017/11/usethis-1.0.0/
}

Control whether news is present on one page or multiple pages with the
\code{one_page} field. The default is \code{true}.\preformatted{news:
- one_page: false
}
}

\seealso{
\href{http://style.tidyverse.org/news.html}{Tidyverse style for News}
}
