% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo-set.R
\name{repo_get}
\alias{repo_get}
\alias{repo_resolve}
\alias{repo_add}
\alias{with_repo}
\title{Query and set the list of CRAN-like repositories}
\usage{
repo_get(
  r_version = getRversion(),
  bioc = TRUE,
  cran_mirror = default_cran_mirror()
)

repo_resolve(spec)

repo_add(..., .list = NULL)

with_repo(repos, expr)
}
\arguments{
\item{r_version}{R version(s) to use for the Bioconductor repositories,
if \code{bioc} is \code{TRUE}.}

\item{bioc}{Whether to add Bioconductor repositories, even if they
are not configured in the \code{repos} option.}

\item{cran_mirror}{The CRAN mirror to use, see
\code{\link[=default_cran_mirror]{default_cran_mirror()}}.}

\item{spec}{A single repository specification, a possibly named
character scalar. See details below.}

\item{...}{Repository specifications. See details below.}

\item{.list}{List or character vector of repository specifications,
see details below.}

\item{repos}{A list or character vector of repository specifications.}

\item{expr}{R expression to evaluate.}
}
\value{
\code{repo_get()} returns a data frame with columns:
\itemize{
\item \code{name}: repository name. Names are informational only.
\item \code{url}: repository URL.
\item \code{type}: repository type. This is also informational, currently it
can be \code{cran} for CRAN, \code{bioc} for a Bioconductor repository, and
\code{cranlike}: for other repositories.
\item \code{r_version}: R version that is supposed to be used with this
repository. This is only set for Bioconductor repositories. It is \code{*}
for others. This is also informational, and not used when retrieving
the package metadata.
\item \code{bioc_version}: Bioconductor version. Only set for Bioconductor
repositories, and it is \code{NA} for others.
}

\code{repo_resolve()} returns a named character vector, with the URL(s) of
the repository.

\code{repo_add()} returns the same data frame as \code{repo_get()}, invisibly.

\code{with_repo()} returns the value of \code{expr}.
}
\description{
pkgcache uses the \code{repos} option, see \code{\link[=options]{options()}}. It also automatically
uses the current Bioconductor repositories, see \code{\link[=bioc_version]{bioc_version()}}.
These functions help to query and manipulate the \code{repos} option.
}
\details{
\code{repo_get()} queries the repositories pkgcache uses. It uses the
\code{repos} option (see \link{options}), and also the default Bioconductor
repository.

\code{repo_resolve()} resolves a single repository specification to a
repository URL.

\code{repo_add()} adds a new repository to the \code{repos} option. (To remove
a repository, call \code{option()} directly, with the subset that you want
to keep.)

\code{with_repo()} temporarily adds the repositories in \code{repos},
evaluates \code{expr}, and then resets the configured repositories.
}
\section{Repository specifications}{
The format of a repository specification is a named or unnamed
character scalar. If the name is missing, pkgcache adds a name
automatically. The repository named \code{CRAN} is the main CRAN repository,
but otherwise names are informational.

Currently supported repository specifications:
\itemize{
\item URL pointing to the root of the CRAN-like repository. Example:\preformatted{https://cloud.r-project.org
}
\item \verb{RSPM@<date>}, RSPM (RStudio Package Manager) snapshot, at the
specified date.
\item \verb{RSPM@<package>-<version>} RSPM snapshot, for the day after the
release of \verb{<version>} of \verb{<package>}.
\item \verb{RSPM@R-<version>} RSPM snapshot, for the day after R \verb{<version>}
was released.
\item \verb{MRAN@<date>}, MRAN (Microsoft R Application Network) snapshot, at
the specified date.
\item \verb{MRAN@<package>-<version>} MRAN snapshot, for the
day after the release of \verb{<version>} of \verb{<package>}.
\item \verb{MRAN@R-<version>} MRAN snapshot, for the day
after R \verb{<version>} was released.
}

Notes:
\itemize{
\item See more about RSPM at \url{https://packagemanager.rstudio.com/client/#/}.
\item See more about MRAN snapshots at
\url{https://mran.microsoft.com/timemachine}.
\item All dates (or times) can be specified in the ISO 8601 format.
\item If RSPM does not have a snapshot available for a date, the next
available date is used.
\item Dates that are before the first, or after the last RSPM snapshot
will trigger an error.
\item Dates before the first, or after the last MRAN snapshot will trigger
an error.
\item Unknown R or package versions will trigger an error.
}
}

\examples{
repo_get()
\dontshow{if (pkgcache:::run_examples()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
repo_resolve("MRAN@2020-01-21")
repo_resolve("RSPM@2020-01-21")
repo_resolve("MRAN@dplyr-1.0.0")
repo_resolve("RSPM@dplyr-1.0.0")
repo_resolve("MRAN@R-4.0.0")
repo_resolve("RSPM@R-4.0.0")
\dontshow{\}) # examplesIf}
\dontshow{if (pkgcache:::run_examples()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
with_repo(c(CRAN = "RSPM@dplyr-1.0.0"), repo_get())
with_repo(c(CRAN = "RSPM@dplyr-1.0.0"), meta_cache_list(package = "dplyr"))

with_repo(c(CRAN = "MRAN@2018-06-30"), summary(repo_status()))
\dontshow{\}) # examplesIf}
}
\seealso{
Other repository functions: 
\code{\link{repo_status}()}
}
\concept{repository functions}
