% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{async_detect}
\alias{async_detect}
\title{Find the value of a match, asynchronously}
\usage{
async_detect(.x, .p, ..., .limit = Inf)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.p}{An asynchronous predicate function.}

\item{...}{Additional arguments to the predicate function.}

\item{.limit}{Number of elements to process simulateneously.
If it is 1, then the predicate is applied sequentially.}
}
\value{
A deferred value for the result.
}
\description{
All predicates are running in parallel, and the returned match
is not guaranteed to be the first one.
}
\examples{
\donttest{
synchronise(async_detect(
  c("https://eu.httpbin.org/status/404", "https://eu.httpbin.org",
    "https://eu.httpbin.org/status/403"),
  async_sequence(http_head, function(x) x$status_code == 200)
))
}
}
\seealso{
Other async iterators: \code{\link{async_every}},
  \code{\link{async_filter}}, \code{\link{async_map}}
}
\concept{async iterators}
