% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get.phat.linear}
\alias{get.phat.linear}
\title{Get the pvalue for the linear statistic}
\usage{
get.phat.linear(x, y, method = c("phat2", "saddlepoint", "phat1", "phat3",
  "nested", "mc", "exact"), N.mc = 10^3, mc.cores = 1, N.level = 1000,
  q = 0.2, B = 5 * length(x), do.sd = FALSE)
}
\arguments{
\item{x}{binary vector of treatment assignment}

\item{y}{gene expression measurement matrix}

\item{method}{method to estimate pvalue for the linear statistic}

\item{N.mc}{number of mc samples is method == "mc"}

\item{mc.cores}{number of cores to use in mcapply}

\item{N.level}{number of samples in each level if method == "nested"}

\item{q}{progression quantile if method == "nested"}

\item{B}{number of burn-ins to use if method == "nested"}

\item{do.sd}{logical to indicate whether calculating sd or not}
}
\value{
a list containing phat from different methods
}
\description{
Get the pvalue for the linear statistic
}
\examples{
x <- c(rep(0, 4), rep(1, 4))
y <- c(rnorm(4, 0, 1), rnorm(4, 2 ,1))
get.phat.linear(x, y, method = "saddlepoint")
get.phat.linear(x, y, method = "phat1")
get.phat.linear(x, y, method = "phat2")
get.phat.linear(x, y, method = "phat3")
get.phat.linear(x, y, method = "nested")
get.phat.linear(x, y, method = "mc")
get.phat.linear(x, y, method = "exact")
get.phat.linear(x, y, method = "saddlepoint", do.sd = TRUE)
get.phat.linear(x, y, method = "phat1", do.sd = TRUE)
get.phat.linear(x, y, method = "phat2", do.sd = TRUE)
get.phat.linear(x, y, method = "phat3", do.sd = TRUE)
get.phat.linear(x, y, method = "nested", do.sd = TRUE)
get.phat.linear(x, y, method = "mc", do.sd = TRUE)
get.phat.linear(x, y, method = "exact", do.sd = TRUE)
}
