% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetFixtures.R
\name{GetFixtures}
\alias{GetFixtures}
\title{Get Fixtures}
\usage{
GetFixtures(sportname, leagueIds, since = NULL, isLive = 0)
}
\arguments{
\item{sportname}{The sport name for which to retrieve the fixtures}

\item{leagueIds}{integer vector with league IDs.}

\item{since}{Default=NULL, numeric This is used to receive incremental updates.
Use the value of last from previous fixtures response.}

\item{isLive}{Default=FALSE, boolean if TRUE retrieves ONLY live events if FALSE retrieved all events}
}
\value{
returns a data frame with columns:
\itemize{
\item SportID
\item Last
\item League
\item LeagueID
\item EventID
\item StartTime
\item HomeTeamName
\item AwayTeamName
\item Rotation Number
\item Live Status
\item Status
\item Parlay Status
}
}
\description{
Get Fixtures
}
\examples{
\donttest{
SetCredentials("TESTAPI","APITEST")
AcceptTermsAndConditions(accepted=TRUE)
GetFixtures(sportname = "Badminton",leagueIds = 191545)}
}

