% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_genotype.R
\docType{class}
\name{zenodoArchive}
\alias{zenodoArchive}
\title{zenodoArchive}
\format{
\code{R6Class} object.
}
\value{
Object of \code{R6Class} for modelling an zenodoArchive for ASC cluster files
}
\description{
zenodoArchive

zenodoArchive
}
\examples{
\donttest{
  zenodo_archive <- zenodoArchive$new(
     doi = "10.5281/zenodo.7401189"
  )

  # view available version ins the archive
  archive_versions <- zenodo_archive$get_versions()

  # Getting the available files in the latest zenodo archive version
  files <- zenodo_archive$get_version_files()

  # downloading the first file from the latest archive version
  zenodo_archive$download_zenodo_files()
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{doi}}{zenodoArchive doi, NULL is not supplied}

\item{\code{all_versions}}{zenodoArchive if to return all versions, \code{true} when not specified}

\item{\code{sort}}{zenodoArchive how to sort the records, \code{mostrecent} when not specified}

\item{\code{page}}{zenodoArchive which page to pull in query, \code{1} when not specified}

\item{\code{size}}{zenodoArchive how many records per page,  \code{20} when not specified}

\item{\code{zenodoVersions}}{zenodoArchive doi available version, a storing variable.}

\item{\code{zenodoQuery}}{zenodoArchive doi version query, a storing variable.}

\item{\code{download_file}}{zenodoArchive doi downloads files, a storing variable.}

\item{\code{download_url}}{zenodoArchive doi downloads urls, a storing variable.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-zenodoArchive-new}{\code{zenodoArchive$new()}}
\item \href{#method-zenodoArchive-clean_doi}{\code{zenodoArchive$clean_doi()}}
\item \href{#method-zenodoArchive-zenodo_query}{\code{zenodoArchive$zenodo_query()}}
\item \href{#method-zenodoArchive-get_versions}{\code{zenodoArchive$get_versions()}}
\item \href{#method-zenodoArchive-get_version_files}{\code{zenodoArchive$get_version_files()}}
\item \href{#method-zenodoArchive-download_zenodo_files}{\code{zenodoArchive$download_zenodo_files()}}
\item \href{#method-zenodoArchive-clone}{\code{zenodoArchive$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zenodoArchive-new"></a>}}
\if{latex}{\out{\hypertarget{method-zenodoArchive-new}{}}}
\subsection{Method \code{new()}}{
initializes the zenodoArchive
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zenodoArchive$new(
  doi,
  page = 1,
  size = 20,
  all_versions = "true",
  sort = "mostrecent"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{doi}}{A zenodo doi. To retrieve all records supply a concept doi (a generic doi common to all versions).}

\item{\code{page}}{Which page to query. Default is 1}

\item{\code{size}}{How many records per page. Default is 20}

\item{\code{all_versions}}{If to return all concept doi versions. If \code{true} returns all, if \code{false} returns the latest. Default is \code{ture}}

\item{\code{sort}}{Which sorting to apply on the records. Default is \code{mostrecent}. Possible sortings "bestmatch", "mostrecent", "-mostrecent" (ascending), "version", "-version" (ascending).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zenodoArchive-clean_doi"></a>}}
\if{latex}{\out{\hypertarget{method-zenodoArchive-clean_doi}{}}}
\subsection{Method \code{clean_doi()}}{
cleans the doi record for query
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zenodoArchive$clean_doi(doi = self$doi)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{doi}}{The zenodo archive doi}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the clean doi
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zenodoArchive-zenodo_query"></a>}}
\if{latex}{\out{\hypertarget{method-zenodoArchive-zenodo_query}{}}}
\subsection{Method \code{zenodo_query()}}{
Query the zenodo archive according to the initial parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zenodoArchive$zenodo_query(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Excepts the self created by \code{initialize}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list with the query values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zenodoArchive-get_versions"></a>}}
\if{latex}{\out{\hypertarget{method-zenodoArchive-get_versions}{}}}
\subsection{Method \code{get_versions()}}{
Extract all concept doi available versions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zenodoArchive$get_versions(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Excepts the self created by \code{initialize}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a data.frame of the available versions.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zenodoArchive-get_version_files"></a>}}
\if{latex}{\out{\hypertarget{method-zenodoArchive-get_version_files}{}}}
\subsection{Method \code{get_version_files()}}{
get the chosen doi archive version available files
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zenodoArchive$get_version_files(version = "latest")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{which archive version files to get. Default to latest. To see all available version use \code{get_versions}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list of the available files in the archive version.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zenodoArchive-download_zenodo_files"></a>}}
\if{latex}{\out{\hypertarget{method-zenodoArchive-download_zenodo_files}{}}}
\subsection{Method \code{download_zenodo_files()}}{
get the chosen doi archive version available files
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zenodoArchive$download_zenodo_files(
  file = NULL,
  path = tempdir(),
  version = "latest",
  all_files = F,
  get_file_path = F,
  quite = F
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{If supplied, downloads the specific file from the archive.}

\item{\code{path}}{The output folder for saving the archive files. Default is to a temporary directory.}

\item{\code{version}}{which archive version files to get. Default to latest. To see all available version use \code{get_versions}}

\item{\code{all_files}}{Logical (FALSE by default). Do you want to download all files in the archive.}

\item{\code{get_file_path}}{Logical (FALSE by default). Do you want to return the path for the file downloaded.}

\item{\code{quite}}{Logical (FALSE by default). Do you want to suppress informative messages}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{get_file_path} is TRUE, the function returns the path to the archive file
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zenodoArchive-clone"></a>}}
\if{latex}{\out{\hypertarget{method-zenodoArchive-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zenodoArchive$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
