% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pp_utils}
\alias{pp_utils}
\alias{get_embedded_font}
\alias{inch}
\alias{to_x}
\alias{to_y}
\alias{to_r}
\alias{to_t}
\alias{cleave}
\alias{file2grob}
\title{\code{piecepackr} utility functions}
\usage{
get_embedded_font(font, char)

inch(inches)

to_x(t, r)

to_y(t, r)

to_r(x, y)

to_t(x, y)

cleave(s, sep = ",", float = FALSE, color = FALSE)

file2grob(file, distort = TRUE)
}
\arguments{
\item{font}{A character vector of font(s) passed to the \code{fontfamily} argument of \code{grid::gpar}.}

\item{char}{A character vector of character(s) to be embedded by \code{grid::grid.text}}

\item{inches}{Number representing number of inches}

\item{t}{Polar angle in degrees}

\item{r}{Radial distance}

\item{x}{Cartesian x coordinate}

\item{y}{Cartesian y coordinate}

\item{s}{String to convert}

\item{sep}{Delimiter (defaults to ",")}

\item{float}{If `TRUE` cast to numeric}

\item{color}{if `TRUE` convert empty strings to `"transparent"`}

\item{file}{Filename of image}

\item{distort}{Logical value of whether one should preserve the aspect ratio
or distort to fit the area it is drawn in}
}
\value{
\code{get_embedded_font} returns character vector of fonts that were actually embedded by \code{cairo_pdf}.
        \code{NA}'s means no embedded font detected: this either means that no font
         was found or that a color emoji font was found and instead of a font an image was embedded.
}
\description{
\code{get_embedded_font} returns which font is actually embedded by \code{cairo_pdf}.
\code{cleave} converts a delimiter separated string into a vector.
\code{inch(x)} is equivalent to \code{unit(x, "in")}.
\code{to_x}, \code{to_y}, \code{to_r}, \code{to_t} convert between polar coordinates (in degrees)
and Cartesian coordinates.
}
\details{
\code{get_embedded_font} depends on \code{pdffonts} being on the system path
         (on many OSes found in a \code{poppler-utils} package).
}
\examples{
 to_x(90, 1)
 to_y(180, 0.5)
 to_t(0, -1)
 to_r(0.5, 0)

 cleave("0.5,0.2,0.4,0.5", float=TRUE)
 cleave("black,darkred,#050EAA,,", color=TRUE)

 if (require("grid")) {
     grid.rect(width=inch(1), height=inch(3), gp=gpar(fill="blue"))
 }
 if ((Sys.which("pdffonts") != "") && capabilities("cairo")) {
     chars <- c("a", "\u2666")
     fonts <- c("sans", "Sans Noto", "Noto Sans", "Noto Sans Symbols2")
     get_embedded_font(fonts, chars)
 }

}
