% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/game_systems.R
\name{game_systems}
\alias{game_systems}
\title{Standard game systems}
\usage{
game_systems(style = NULL)
}
\arguments{
\item{style}{If \code{NULL} (the default) uses suit glyphs from the default \dQuote{sans} font.
If \code{"dejavu"} it will use suit glyphs from the "DejaVu Sans" font (must be installed on the system).}
}
\description{
\code{game_systems} returns a list of \code{pp_cfg} objects
representing several game systems.
}
\details{
Contains the following game systems:\itemize{
\item{icehouse pieces}
\item{piecepack plus several piecepack accessories/expansions:\itemize{
  \item{piecepack matchsticks}
  \item{piecepack pyramids}
  \item{piecepack saucers}
  \item{hexpack}
  \item{playing cards expansion}
  \item{dual piecepacks expansion}
  \item{(stackpack) subpack aka mini piecepack}
}}}
}
\examples{
       cfgs <- game_systems()
       names(cfgs)

       df_tiles <- data.frame(piece_side="tile_back", x=0.5+c(3,1,3,1), y=0.5+c(3,3,1,1),
                              suit=NA, angle=NA, z=NA, stringsAsFactors=FALSE)
       df_coins <- data.frame(piece_side="coin_back", x=rep(4:1, 4), y=rep(4:1, each=4),
                              suit=c(1,4,1,4,4,1,4,1,2,3,2,3,3,2,3,2),
                              angle=rep(c(180,0), each=8), z=1/4+1/16, stringsAsFactors=FALSE)
       df <- rbind(df_tiles, df_coins)
       df$cfg <- "playing_cards_expansion"

       pmap_piece(df, envir=cfgs, op_scale=0.5, default.units="in")
}
\seealso{
\code{\link{pp_cfg}} for information about the \code{pp_cfg} objects returned by \code{game_systems}.
}
