% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-font.R
\name{font_utils}
\alias{font_utils}
\alias{get_embedded_font}
\alias{has_font}
\title{Font utility functions}
\usage{
get_embedded_font(font, char)

has_font(font)
}
\arguments{
\item{font}{A character vector of font(s).}

\item{char}{A character vector of character(s) to be embedded by \code{grid::grid.text()}}
}
\value{
\code{get_embedded_font()} returns character vector of fonts that were actually embedded by \code{cairo_pdf()}.
\code{NA}'s means no embedded font detected: this either means that no font
was found or that a color emoji font was found and instead of a font an image was embedded.
}
\description{
\code{get_embedded_font()} returns which font is actually embedded
by \code{cairo_pdf()} for a given character.
\code{has_font()} tries to determine if a given font is available on the OS.
}
\details{
\code{get_embedded_font()} depends on the suggested \code{pdftools} package being installed
and R being compiled with Cairo support.
\code{has_font()} depends on either the suggested \code{systemfonts} (preferred) or \code{pdftools}
packages being installed.
}
\examples{
 if (requireNamespace("pdftools", quietly = TRUE) &&
     capabilities("cairo") &&
     !piecepackr:::is_cairo_maybe_buggy()) {
   chars <- c("a", "\u2666")
   fonts <- c("sans", "Sans Noto", "Noto Sans", "Noto Sans Symbols2")
   try(get_embedded_font(fonts, chars))
 }

 if (requireNamespace("systemfonts", quietly = TRUE) ||
     (requireNamespace("pdftools", quietly = TRUE) &&
      capabilities("cairo")) && !piecepackr:::is_cairo_maybe_buggy()) {
   try(has_font("Dejavu Sans"))
 }
}
