% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/space.R
\name{space_punctuation}
\alias{space_punctuation}
\title{Add Spaces Around Punctuation}
\usage{
space_punctuation(text, space_hyphens = TRUE, space_abbreviations = TRUE)
}
\arguments{
\item{text}{A character vector to clean.}

\item{space_hyphens}{Logical; treat hyphens between letters and at the
start/end of words as punctuation? Other hyphens are always treated as
punctuation.}

\item{space_abbreviations}{Logical; treat apostrophes between letters as
punctuation? Other apostrophes are always treated as punctuation.}
}
\value{
A character vector the same length as the input text, with spaces
added around punctuation characters.
}
\description{
To keep punctuation during tokenization, it's convenient to add spacing
around punctuation. This function does that, with options to keep certain
types of punctuation together as part of the word.
}
\examples{
to_space <- "This is some 'gosh-darn' $5 text. Isn't it lovely?"
to_space
space_punctuation(to_space)
space_punctuation(to_space, space_hyphens = FALSE)
space_punctuation(to_space, space_abbreviations = FALSE)
}
