% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-special.R
\name{write_sqs}
\alias{write_sqs}
\title{Write out sequences}
\usage{
write_sqs(phylota, outfile, sid, sq_nm = sid, width = 80)
}
\arguments{
\item{phylota}{Phylota}

\item{outfile}{Output file}

\item{sid}{Sequence ID(s)}

\item{sq_nm}{Sequence name(s)}

\item{width}{Maximum number of characters in a line, integer}
}
\description{
Write out sequences, as .fasta, for a given vector of IDs.
}
\details{
The user can control the output definition lines of the sequences using the
sq_nm. By default sequences IDs are used. Note, ensure the sq_nm are in the
same order as sid.
}
\examples{
data('aotus')
# get sequences for a cluster and write out
random_cid <- sample(aotus@cids, 1)
sids <- aotus[[random_cid]]@sids
write_sqs(phylota = aotus, outfile = file.path(tempdir(), 'test.fasta'),
          sq_nm = 'my_gene', sid = sids)
}
\seealso{
Other tools-public: \code{\link{calc_mad}},
  \code{\link{calc_wrdfrq}}, \code{\link{drop_by_rank}},
  \code{\link{drop_clstrs}}, \code{\link{drop_sqs}},
  \code{\link{get_clstr_slot}}, \code{\link{get_nsqs}},
  \code{\link{get_ntaxa}}, \code{\link{get_sq_slot}},
  \code{\link{get_stage_times}}, \code{\link{get_tx_slot}},
  \code{\link{get_txids}}, \code{\link{is_txid_in_clstr}},
  \code{\link{is_txid_in_sq}},
  \code{\link{list_clstrrec_slots}},
  \code{\link{list_ncbi_ranks}},
  \code{\link{list_seqrec_slots}},
  \code{\link{list_taxrec_slots}},
  \code{\link{plot_phylota_pa}},
  \code{\link{plot_phylota_treemap}},
  \code{\link{read_phylota}}
}
