% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline.R
\name{parameters_reset}
\alias{parameters_reset}
\title{Change parameters in a working directory}
\usage{
parameters_reset(wd, parameters, values)
}
\arguments{
\item{wd}{Working directory}

\item{parameters}{Parameters to be changed, vector.}

\item{values}{New values for each parameter, vector.}
}
\description{
Reset parameters after running \code{setup()}.
}
\examples{
\dontrun{
  
  # Note: this example requires BLAST and internet to run.
  
  # example with temp folder
  wd <- file.path(tempdir(), 'aotus')
  # setup for aotus, make sure aotus/ folder already exists
  if (!dir.exists(wd)) {
    dir.create(wd)
  }
  ncbi_dr <- '[SET BLAST+ BIN PATH HERE]'
  setup(wd = wd, txid = 9504, ncbi_dr = ncbi_dr)  # txid for Aotus primate genus
  # run
  # run(wd = wd) # not running in test
  # use ctrl+c or Esc to kill
  # change parameters, e.g. min and max sequence lengths
  parameters_reset(wd = 'aotus', parameters = c('mnsql', 'mxsql'),
                   values = c(300, 1500))
  # see ?parameters
  # restart
  restart(wd = wd)
}
}
\seealso{
Other run-public: \code{\link{ClstrArc-class}},
  \code{\link{ClstrRec-class}},
  \code{\link{Phylota-class}}, \code{\link{SeqArc-class}},
  \code{\link{SeqRec-class}}, \code{\link{TaxDict-class}},
  \code{\link{TaxRec-class}}, \code{\link{clusters2_run}},
  \code{\link{clusters_run}}, \code{\link{reset}},
  \code{\link{restart}}, \code{\link{run}},
  \code{\link{setup}}, \code{\link{taxise_run}}
}
