% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.R
\docType{class}
\name{TaxRec-class}
\alias{TaxRec-class}
\alias{TaxRec-method}
\alias{as.character,TaxRec-method}
\alias{show,TaxRec-method}
\alias{print,TaxRec-method}
\alias{str,TaxRec-method}
\alias{summary,TaxRec-method}
\title{Taxonomic record}
\usage{
\S4method{as.character}{TaxRec}(x)

\S4method{show}{TaxRec}(object)

\S4method{print}{TaxRec}(x)

\S4method{str}{TaxRec}(object, max.level = 2L, ...)

\S4method{summary}{TaxRec}(object)
}
\arguments{
\item{x}{\code{TaxRec} object}

\item{object}{\code{TaxRec} object}

\item{max.level}{Maximum level of nesting for str()}

\item{...}{Further arguments for str()}
}
\description{
Taxonomic dictionary contains a taxonomic
tree and NCBI taxonomy data for all taxonomic IDs.
}
\section{Slots}{

\describe{
\item{\code{id}}{Taxonomic ID}

\item{\code{scnm}}{Scientific name}

\item{\code{cmnm}}{Common name}

\item{\code{rnk}}{Rank}

\item{\code{lng}}{Lineage}

\item{\code{prnt}}{Parent}
}}

\examples{
data('aotus')
taxrec <- aotus@txdct@recs[[aotus@txdct@txids[[1]]]]
# this is a TaxRec object
# it contains NCBI's taxonomic information for a single node
show(taxrec)
# you can access its different data slots with @
taxrec@id    # taxonomic ID
taxrec@scnm  # scientific name
taxrec@cmnm  # common name, '' if none
taxrec@rnk   # rank
taxrec@lng   # lineage information: list of IDs and ranks
taxrec@prnt  # parent ID
}
\seealso{
Other run-public: \code{\link{ClstrArc-class}},
  \code{\link{ClstrRec-class}},
  \code{\link{Phylota-class}}, \code{\link{SeqArc-class}},
  \code{\link{SeqRec-class}}, \code{\link{TaxDict-class}},
  \code{\link{clusters2_run}}, \code{\link{clusters_run}},
  \code{\link{parameters_reset}}, \code{\link{reset}},
  \code{\link{restart}}, \code{\link{run}},
  \code{\link{setup}}, \code{\link{taxise_run}}
}
