%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Do not modify this file since it was automatically generated from:
% 
%  ./PhyloSimSource.R
% 
% by the Rdoc compiler part of the R.oo package.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 \name{QMatrix}
\docType{class}
\alias{QMatrix}


 \title{The QMatrix class}

 \description{
	This is the class representing rate matrices. The QMatrix objects store two rate matrices: one contains
       the rates provided by the user (unscaled rate matrix), the other matrix (scaled rate matrix) is rescaled so the
       expected number of subsitutions per unit time is equal to one when the process is at equlibrium.
	The scaled rate matrices, along with the site-process-specific rate multiplier
	parameters define the rates of the Event objects generated by the associated GeneralSubstitution objects.         

	The QMatrix objects have a bidirectonal relationship with the GeneralSubstitution object as they store a reference
	to the associated process objects. QMatrix objects do not have a write-protection field, but they use the one
	from the associated GeneralSubstitution object.

	Usually there is no need to interact with the QMatrix objects directly, so this class
	is mainly used internally.

	Package:   \cr
\bold{Class QMatrix}\cr

\code{\link[R.oo]{Object}}\cr
\code{~~|}\cr
\code{~~+--}\code{\link{PSRoot}}\cr
\code{~~~~~~~|}\cr
\code{~~~~~~~+--}\code{QMatrix}\cr

\bold{Directly known subclasses:}\cr
\cr

public static class \bold{QMatrix}\cr
extends \link{PSRoot}\cr


 }

 \usage{QMatrix(name="Anonymous", alphabet=NA, rate.list=NA, process=NA, ...)}

 \arguments{
 	\item{name}{The name of the QMatrix object (a character vector of length one).}
	\item{alphabet}{An Alphabet object.}
	\item{rate.list}{A list of unscaled event rates and the associated event names. It will be passed to the \code{setRateList.QMatrix} method.}
	\item{process}{A GeneralSubstitution object to be associated with the QMatrix object.}
 	\item{...}{Not used.}
	}

 \section{Fields and Methods}{
 	\bold{Methods:}\cr
\tabular{rll}{
 \tab \code{as.character} \tab  -\cr
 \tab \code{checkConsistency} \tab  -\cr
 \tab \code{getAlphabet} \tab  -\cr
 \tab \code{getEventRate} \tab  -\cr
 \tab \code{getId} \tab  -\cr
 \tab \code{getMatrix} \tab  -\cr
 \tab \code{getName} \tab  -\cr
 \tab \code{getProcess} \tab  -\cr
 \tab \code{getRateList} \tab  -\cr
 \tab \code{getRate} \tab  -\cr
 \tab \code{getScaledMatrix} \tab  -\cr
 \tab \code{getWriteProtected} \tab  -\cr
 \tab \code{is} \tab  -\cr
 \tab \code{print} \tab  -\cr
 \tab \code{Scale} \tab  -\cr
 \tab \code{setAlphabet} \tab  -\cr
 \tab \code{setId} \tab  -\cr
 \tab \code{setMatrix} \tab  -\cr
 \tab \code{setName} \tab  -\cr
 \tab \code{setProcess} \tab  -\cr
 \tab \code{setRateList} \tab  -\cr
 \tab \code{setRate} \tab  -\cr
 \tab \code{setScaledMatrix} \tab  -\cr
 \tab \code{setWriteProtected} \tab  -\cr
 \tab \code{summary} \tab  -\cr
}


 \bold{Methods inherited from PSRoot}:\cr
checkConsistency, enableVirtual, getComments, getMethodsList, globalConsistencyCheck, intersect.list, is.na, is, ll, my.all.equal, plot, setComments, setMethodsList, summary, virtualAssignmentForbidden

 \bold{Methods inherited from Object}:\cr
as.character, attachLocally, attach, clearCache, clearLookupCache, clone, detach, equals, extend, finalize, gc, getEnvironment, getFieldModifier, getFieldModifiers, getFields, getInstantiationTime, getStaticInstance, hasField, hashCode, ll, load, [[<-, [[, $<-, $, objectSize, print, registerFinalizer, save

 }

 \examples{
	# create a QMatrix object by providing an Alphabet object and rates
	m<-QMatrix(name="Susie Q", alphabet=BinaryAlphabet(), rate.list=list("1->0"=2,"0->1"=3))
	# get object summary
	summary(m)
       # create a GeneralSubstitution object by
       # providing an Alphabet object and the rates
       p<-GeneralSubstitution(alphabet=BinaryAlphabet(), rate.list=list("1->0"=1,"0->1"=3))
       # get the QMatrix object from p
       m<-p$QMatrix
	# get various object properties
	m
	is.QMatrix(m)
	m$name
	m$id
	m$alphabet
	# get the associated process
	m$process
	# get the unscaled rate of "0->1"
	getRate(m,"0->1")
	# get the scaled rate of "0->1"
	getEventRate(m,"0->1")
	# get the list of unscaled rates
	m$rateList
	# get unscaled rate matrix
	m$matrix
	# get scaled rate matrix
	m$scaledMatrix
 }

 \author{Botond Sipos}

 \seealso{
 	GeneralSubstitution Alphabet Process
 }
