% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.swatch.R
\name{plot_swatch}
\alias{plot_swatch}
\title{Plot shapefile polygons based on slot values}
\usage{
plot_swatch(
  x,
  values = NULL,
  col = hcl.colors(n = 10, palette = "Blue-Red 3", rev = FALSE),
  key_label = "",
  leg = 10,
  lwd = 15,
  pos = "bottomleft",
  legend = TRUE,
  border = par("fg"),
  breaks = "quantile",
  min = NULL,
  max = NULL,
  ...
)
}
\arguments{
\item{x}{A data frame or object of the class SpatialPolygonsDataFrame}

\item{values}{Variable in the SpatialPolygonsDataFrame for which to
discretize the values of the quantity.}

\item{col}{A vector of colors}

\item{key_label}{label for the color key}

\item{leg}{Numeric, length of the legend}

\item{lwd}{numeric, line width of the legend.}

\item{pos}{location to position the legend such as \dQuote{bottomright},
\dQuote{bottomleft}, \dQuote{topleft}, and \dQuote{topright}.}

\item{legend}{logical indicating whether to add a legend to the map.}

\item{border}{plot polygons in SpatialPolygons object}

\item{breaks}{one of \dQuote{equal}, \dQuote{pretty}, \dQuote{jenks},
\dQuote{quantile} or numeric with the actual breaks by specifying
the minimum (\code{min}) and maximum (\code{max}) bounds.}

\item{min}{the minima of the lowest bound of the break.}

\item{max}{the maxima of the upper bound of the break}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Returns no value, just map swatch of colors in geographic space!
}
\description{
\code{plot_swatch} maps discretized values of a quantity using
continuous color gradients.
}
\examples{
library(sp)
s <- readRDS(system.file("nigeria/SR_Naija.rds", package = "phyloregion"))
plot_swatch(s, values = s$SR)
}
\seealso{
\code{\link[sp]{SpatialPolygons-class}}
}
\author{
Barnabas H. Daru \email{darunabas@gmail.com}
}
\keyword{and}
\keyword{mapping}
\keyword{visualization}
