\name{PLD_loc_mrca}

\alias{PLD_loc_mrca}

\title{
Location of Most Recent Common Ancestor
}

\description{
Function that returns the posterior distribution of the geographic locations of the Most Recent Common Ancestor of a set of tips.
A barplot can be generated.}

\usage{
PLD_loc_mrca(x, tips, sub_sample = 0, plot_distrib = FALSE, col = NA)
}


\arguments{
  \item{x}{
an object of class "phyloland" generated by a call to \link{PLD_interface}.
}

  \item{tips}{
a vector of character strings specifying the set of tips.
}

  \item{sub_sample}{
a vector of integers that specifies the indexes of the trees and locations to take into account.
Default is 0, all the trees and locations are considered.
}

  \item{plot_distrib}{
a logical value, if TRUE a barplot is plotted.
The default is FALSE.
}

  \item{col}{
a set of colors for the barplot.
}
}

\value{
 \item{frequencies}{  matrix with 3 columns containing location latitudes, longitudes and frequencies.}
 \item{locationsMRCA}{  vector containing all the \code{sub_sample} sampled locations for the \code{tips} Most Recent Common Ancestor.}
}

\examples{
data(Banza)
locations = PLD_loc_mrca(x = Banza, tips = Banza$tips, sub_sample = 100:200, plot_distrib = TRUE)
locations$frequencies
}

