% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitTop.R
\name{splitTop}
\alias{splitTop}
\title{Split topology}
\usage{
splitTop(tree, dist)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}

\item{dist}{integer distance of nodes of interest from the root.}
}
\value{
A vector of integers, each corresponding to the clade size of a node at the given distance from the root. The clade sizes are given in ascending order and each is labelled by its node name or number.
This vector can be considered as a partition of the tips or the "split topology" of the tree at a given depth.
}
\description{
For each node at a given distance from the root, this function finds the size of its induced subclade, i.e. its number of tip descendants.
}
\examples{
## Find the split topology of a random tree with 20 tips, at a distance 2 from the root:
tree <- rtree(20)
plot(tree)
splitTop(tree,2)


}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}

Michael Boyd \email{mboyd855@gmail.com}
}

