% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dob_from_chi.R
\name{age_from_chi}
\alias{age_from_chi}
\title{Extract age from the CHI number}
\usage{
age_from_chi(
  chi_number,
  ref_date = NULL,
  min_age = 0,
  max_age = NULL,
  chi_check = TRUE
)
}
\arguments{
\item{chi_number}{a CHI number or a vector of CHI numbers with \code{character}
class.}

\item{ref_date}{calculate the age at this date, default is to use
\code{Sys.Date()} i.e. today.}

\item{min_age, max_age}{optional min and/or max dates that the DoB could take
as the century needs to be guessed.
Must be either length 1 for a 'fixed' age or the same length as \code{chi_number}
for an age per CHI number.
\code{min_age} can be age based on common sense in the dataset, whilst \code{max_age}
can be age when an event happens such as the age at discharge.}

\item{chi_check}{logical, optionally skip checking the CHI for validity which
will be faster but should only be used if you have previously checked the
CHI(s), the default (TRUE) will to check the CHI numbers.}
}
\value{
an integer vector of ages in years truncated to the nearest year.
It will be the same length as \code{chi_number}.
}
\description{
\code{age_from_chi} takes a CHI number or a vector of CHI numbers
and returns the age as implied by the CHI number(s). If the Date of Birth
(DoB) is ambiguous it will return NA. It uses \code{\link[=dob_from_chi]{dob_from_chi()}}.
}
\examples{
age_from_chi("0101336489")

library(tibble)
library(dplyr)
data <- tibble(chi = c(
  "0101336489",
  "0101405073",
  "0101625707"
), dis_date = as.Date(c(
  "1950-01-01",
  "2000-01-01",
  "2020-01-01"
)))

data \%>\%
  mutate(chi_age = age_from_chi(chi))

data \%>\%
  mutate(chi_age = age_from_chi(chi, min_age = 18, max_age = 65))

data \%>\%
  mutate(chi_age = age_from_chi(chi,
    ref_date = dis_date
  ))
}
