% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreeqc.R
\name{phrSetOutputFileOn}
\alias{phrSetOutputFileOn}
\title{Set output file on/off.}
\usage{
phrSetOutputFileOn(value)
}
\arguments{
\item{value}{if TRUE, writes output to the the output file.}
}
\description{
Sets the output file switch on or off. This switch controls whether
or not phreeqc writes to the output file. This is the output normally
generated when phreeqc is run. The initial setting is off.
}
\examples{

# This example runs ex2 with the output file turned on.

# write temporary input file
tf <- tempfile()
writeLines(ex2, tf)

# load database and run input file
phrLoadDatabaseString(phreeqc.dat)
phrSetOutputFileOn(TRUE)
phrSetOutputFileName(file.path(tempdir(), "ex2.out"))
if (is.null(phrRunFile(tf))) {
  cat(paste("see ", phrGetOutputFileName(), ".\n", sep = ""))
}

# delete temporary input file
unlink(tf)

}
\references{
\url{https://water.usgs.gov/water-resources/software/PHREEQC/IPhreeqc.pdf}
}
\seealso{
Other Output: 
\code{\link{phrGetOutputFileName}()},
\code{\link{phrGetOutputFileOn}()},
\code{\link{phrGetOutputStringsOn}()},
\code{\link{phrGetOutputStrings}()},
\code{\link{phrSetOutputFileName}()},
\code{\link{phrSetOutputStringsOn}()}
}
\concept{Output}
