# Copyright (c) 2014 Santiago Barreda
# All rights reserved.


resample = function (sound, newfs, oldfs, precision = 50, filterorder = 200){
  soundout = 0
  if (class(sound) == "sound") {
    soundout = 1
    oldsound = sound
    oldfs = sound$fs
    sound = sound$sound
  } 
  ratio = oldfs / newfs 
  if (ratio > 1) sound = FIRfilter (sound, to = newfs/2, fs = oldfs, order = filterorder)

  newtime = seq (1, length(sound)+1, by = ratio)   
  nearest = round (newtime)                              
  offset = newtime - nearest                                 

  sound = c(rep(0,precision), sound, rep(0,precision+1))
  y = newtime * 0

  for (i in -precision:precision)
    y = y + sound[nearest+precision+i] * sinc(offset - i, normalized = TRUE)

  if (ratio < 1) y = FIRfilter (y, to = oldfs/2, fs = newfs, order = filterorder)
 
  sound = y / (max(y) * 1.05) 
  if (soundout == 1)  sound = makesound (sound, filename = oldsound$filename, fs = newfs)
  return (sound)   
}
