#' plot.phenology plots the phenology.
#' @title Plot the phenology from a result.
#' @author Marc Girondot
#' @return Return A list of lists with formated outputs\cr
#' For each site:\cr
#' $site=name of the site\cr
#' $estimate1=Estimation of counts not taking into account the observations\cr
#' $sd1=The SD of estimation1\cr
#' $estimate2=Estimation of counts taking into account the observations\cr
#' $sd2=The SD of estimation2
#' @param x A result file generated by fit_phenology
#' @param ... Parameters used by plot_phenology
#' @description The function "plot_phenology" plots the phenology graph from a result.
#' @examples
#' library(phenology)
#' # Read a file with data
#' # Gratiot<-read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", , header=FALSE)
#' data(Gratiot)
#' # Generate a formatted list nammed data_Gratiot 
#' data_Gratiot<-add_format(origin=NULL, add=Gratiot, name="Complete", reference=as.Date("2001-01-01"), format="%d/%m/%Y")
#' # Generate initial points for the optimisation
#' parg<-par_init(data_Gratiot, parametersfixed=NULL)
#' # Run the optimisation
#' # result_Gratiot<-fit_phenology(data=data_Gratiot, parametersfit=parg, parametersfixed=NULL, trace=1)
#' data(result_Gratiot)
#' # Plot the phenology and get some stats
#' output<-plot(result_Gratiot, pdf=FALSE)
#' @method plot phenology
#' @export

plot.phenology <- function(x, ...) {

# result=NULL, data=NULL, parameters=NULL, parametersfixed=NA, series="all", pdf=FALSE, moon=FALSE, help=FALSE, ...

	es <- c(...)
	
	if (is.null(es)) es <- NA
	
	esdata <- es["data"]
	if (is.na(esdata)) {
		esdata <- NULL
	} else {
		es <- es[-which(names(es)=="data")]
	}
	
	esparameters <- es["parameters"]
	if (is.na(esparameters)) {
		esparameters <- NULL
	} else {
		es <- es[-which(names(es)=="parameters")]
	}
	
	esparametersfixed <- es["parametersfixed"]
	if (is.na(esparametersfixed)) {
		esparametersfixed <- NA
	} else {
		es <- es[-which(names(es)=="parametersfixed")]
	}
	
	esseries <- es["series"]
	if (is.na(esseries)) {
		esseries <- "all"
	} else {
		es <- es[-which(names(es)=="series")]
	}
	
	espdf <- es["pdf"]
	if (is.na(espdf)) {
		espdf <- FALSE
	} else {
		es <- es[-which(names(es)=="pdf")]
	}

	esmoon <- es["moon"]
	if (is.na(esmoon)) {
		esmoon <- FALSE
	} else {
		es <- es[-which(names(es)=="moon")]
	}

	eshelp <- es["help"]
	if (is.na(eshelp)) {
		eshelp <- FALSE
	} else {
		es <- es[-which(names(es)=="help")]
	}
	

	out <- plot_phenology(result=x, data=esdata, parameters=esparameters, parametersfixed=esparametersfixed, series=esseries, pdf=espdf, moon=esmoon, help=eshelp, es)

	return(out)

}
