% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_FUN.R
\name{opt_FUN}
\alias{opt_FUN}
\alias{opt_ucminf}
\alias{opt_nlminb}
\alias{opt_nlm}
\alias{opt_optim}
\title{Unified optimization function}
\usage{
opt_ucminf(par0, objective, ...)

opt_nlminb(par0, objective, ...)

opt_nlm(par0, objective, ...)

opt_optim(par0, objective, method = "BFGS", ...)
}
\arguments{
\item{par0}{Initial values for the parameters to be optimized over.}

\item{objective}{A function to be minimized (or maximized), with first
argument the vector of parameters over which minimization is to take place.
It should return a scalar result.}

\item{...}{other parameters passed to \code{objective}.}

\item{method}{optimization method to be used in \code{p_optim}. See
\code{\link[stats:optim]{stats::optim()}}.}
}
\value{
\itemize{
\item \code{convcode}: An integer code. 0 indicates successful convergence.
Various methods may or may not return sufficient information to allow all
the codes to be specified. An incomplete list of codes includes
\itemize{
\item \code{1}: indicates that the iteration limit \code{maxit} had been reached.
\item \code{20}: indicates that the initial set of parameters is inadmissible,
that is, that the function cannot be computed or returns an infinite,
NULL, or NA value.
\item \code{21}: indicates that an intermediate set of parameters is inadmissible.
\item \code{10}: indicates degeneracy of the Nelder--Mead simplex.
\item \code{51}: indicates a warning from the \code{"L-BFGS-B"} method; see component
\code{message} for further details.
\item \code{52}: indicates an error from the \code{"L-BFGS-B"} method; see component
\code{message} for further details.
\item \code{9999}: error
}
\item \code{value}: The value of fn corresponding to par
\item \code{par}: The best parameter found
\item \code{nitns}: the number of iterations
\item \code{fevals}: The number of calls to \code{objective}.
}
}
\description{
\code{I_optimx} is rich of functionality, but with a low computing
performance. Some basic optimization functions are unified here, with some
input and output format. \cr
\itemize{
\item \code{opt_ncminf} General-Purpose Unconstrained Non-Linear Optimization,
see \code{\link[ucminf:ucminf]{ucminf::ucminf()}}.
\item \code{opt_nlminb} Optimization using PORT routines, see \code{\link[stats:nlminb]{stats::nlminb()}}.
\item \code{opt_nlm} Non-Linear Minimization, \code{\link[stats:nlm]{stats::nlm()}}.
\item \code{opt_optim} General-purpose Optimization, see \code{\link[stats:optim]{stats::optim()}}.
}
}
\examples{
library(phenofit)
library(ggplot2)
library(magrittr)
library(purrr)

# simulate vegetation time-series
fFUN = doubleLog.Beck
par = c(
  mn  = 0.1,
  mx  = 0.7,
  sos = 50,
  rsp = 0.1,
  eos = 250,
  rau = 0.1)
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
y <- fFUN(par, t)

# initial parameter
par0 <- c(
  mn  = 0.15,
  mx  = 0.65,
  sos = 100,
  rsp = 0.12,
  eos = 200,
  rau = 0.12)

objective <- f_goal # goal function
optFUNs   <- c("opt_ucminf", "opt_nlminb", "opt_nlm", "opt_optim") \%>\% set_names(., .)

opts <- lapply(optFUNs, function(optFUN){
    optFUN <- get(optFUN)
    opt <- optFUN(par0, objective, y = y, t = t, fun = fFUN)
    opt$ysim <- fFUN(opt$par, t)
    opt
})

# visualization
df   <- map(opts, "ysim") \%>\% as.data.frame() \%>\% cbind(t, y, .)
pdat <- reshape2::melt(df, c("t", "y"), variable.name = "optFUN")

ggplot(pdat) + 
    geom_point(data = data.frame(t, y), aes(t, y), size = 2) + 
    geom_line(aes(t, value, color = optFUN), size = 0.9)

}
\seealso{
\code{\link[=optim_pheno]{optim_pheno()}}, \code{\link[=I_optim]{I_optim()}}
}
