% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rosePlotsAct.R
\name{rosePlotsAct}
\alias{rosePlotsAct}
\title{Generate rose plots for averaged activity data}
\usage{
rosePlotsAct(data, bin = 30, t.cycle = 24, rm.channels = c())
}
\arguments{
\item{data}{Input data file. The input for this function must be the output of the function binData(). See ??binData().}

\item{bin}{Intervals in which data are saved (in minutes). This defaults to 30. This value must be the same as that for binData().}

\item{t.cycle}{Define the period of the environmental cycle or a single day in hours. This defaults to 24. This value must be the same as that for binData().}

\item{rm.channels}{All the channels that users want to remove from their averaging. This must be a vector, i.e., channels must be separated by commas. For instance, if users choose to remove channels 1 to 5, 25 and 32, then the input should be either c(1,2,3,4,5,25,32) or c(1:5,25,32). This defaults to an empty vector, meaning no individuals are removed from analysis.}
}
\value{
A \code{plotly} {htmlwidget} with rose plots for locomotor activity.
}
\description{
Users can generate rose plots for the averaged activity data. The input for this function must be output from binData(). The output of this function is a plotly object. By default the averaging of profiles is done over all flies and days.
}
\examples{
td <- trimData(data = df, start.date = "19 Dec 20", start.time = "21:00",
n.days = 10, bin = 1, t.cycle = 24)
bd <- binData(td)
r.plot <- rosePlotsAct(data = bd)
}
