% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indActogram.R
\name{indActogram}
\alias{indActogram}
\title{Plot actogram of individual fly}
\usage{
indActogram(data, bin = 30, t.cycle = 24, ind = 1, key.acto = 1)
}
\arguments{
\item{data}{Input data file. The input for this function must be the output of the function binData(). See ??binData().}

\item{bin}{Define the bin size (in minutes) in which input data is saved.}

\item{t.cycle}{Define the period of the environmental cycle or a single day in hours. This defaults to 24.}

\item{ind}{The channel number (or individual) whose actogram must be plotted.}

\item{key.acto}{Key for reactive input tables in the shiny app.}
}
\value{
A \code{plotly} \code{htmlwidget} with the actogram of a user defined fly.
}
\description{
Allows users to generate individual actograms. The input for this function must be the output of the binData() function. The output of this function is a plotly object.
}
\examples{
td <- trimData(data = df, start.date = "19 Dec 20", start.time = "21:00",
n.days = 10, bin = 1, t.cycle = 24)
bd <- binData(td)
ind.actogram <- indActogram(data = bd, bin = 30, ind = 2)
}
