% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{has_mixed_mm_fo_elimination}
\alias{has_mixed_mm_fo_elimination}
\title{has_mixed_mm_fo_elimination}
\usage{
has_mixed_mm_fo_elimination(model)
}
\arguments{
\item{model}{(Model) Pharmpy model}
}
\value{
(logical) TRUE if model has describes Michaelis-Menten elimination
}
\description{
Check if the model describes mixed Michaelis-Menten and first order elimination

This function relies on heuristics and will not be able to detect all
possible ways of coding the mixed Michalis-Menten and first order elimination.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
has_mixed_mm_fo_elimination(model)
model <- set_mixed_mm_fo_elimination(model)
has_mixed_mm_fo_elimination(model)
}

}
