% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phacking-package.R
\docType{package}
\name{phacking-package}
\alias{phacking}
\alias{phacking-package}
\title{phacking: Sensitivity Analysis for p-Hacking in Meta-Analyses}
\description{
Fits right-truncated meta-analysis (RTMA), a bias correction for the joint effects of p-hacking (i.e., manipulation of results within studies to obtain significant, positive estimates) and traditional publication bias (i.e., the selective publication of studies with significant, positive results) in meta-analyses [see Mathur MB (2022). "Sensitivity analysis for p-hacking in meta-analyses." \doi{10.31219/osf.io/ezjsx}.]. Unlike publication bias alone, p-hacking that favors significant, positive results (termed "affirmative") can distort the distribution of affirmative results. To bias-correct results from affirmative studies would require strong assumptions on the exact nature of p-hacking. In contrast, joint p-hacking and publication bias do not distort the distribution of published nonaffirmative results when there is stringent p-hacking (e.g., investigators who hack always eventually obtain an affirmative result) or when there is stringent publication bias (e.g., nonaffirmative results from hacked studies are never published). This means that any published nonaffirmative results are from unhacked studies. Under these assumptions, RTMA involves analyzing only the published nonaffirmative results to essentially impute the full underlying distribution of all results prior to selection due to p-hacking and/or publication bias. The package also provides diagnostic plots described in Mathur (2022).
}
\references{
\insertRef{mathur2022phacking}{metabias}

\insertRef{lodder2019}{metabias}

\insertRef{stan2022}{metabias}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/mikabr/phacking}
  \item Report bugs at \url{https://github.com/mikabr/phacking/issues}
}

}
\author{
\strong{Maintainer}: Mika Braginsky \email{mika.br@gmail.com}

Authors:
\itemize{
  \item Maya Mathur \email{mmathur@stanford.edu}
}

}
\keyword{internal}
