/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.io.StringInputStream;
import net.sf.eps2pgf.ps.Parser;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorIOError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectBool;
import net.sf.eps2pgf.ps.objects.PSObjectString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSObjectFile
extends PSObject {
    private InputStream inStr;

    public PSObjectFile(InputStream inputStream) {
        if (inputStream != null) {
            this.setStream(inputStream);
        } else {
            this.setStream(new StringInputStream(""));
        }
        this.setLiteral(false);
    }

    @Override
    public PSObjectFile clone() {
        PSObjectFile pSObjectFile = (PSObjectFile)super.clone();
        return pSObjectFile;
    }

    public void closeFile() throws PSErrorIOError {
        try {
            this.inStr.close();
        }
        catch (IOException iOException) {
            throw new PSErrorIOError();
        }
    }

    @Override
    public PSObjectFile dup() {
        PSObjectFile pSObjectFile = new PSObjectFile(this.inStr);
        pSObjectFile.copyCommonAttributes(this);
        return pSObjectFile;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PSObjectFile) {
            return this.eq((PSObjectFile)object);
        }
        return false;
    }

    public void flushFile() throws PSError {
        try {
            int n;
            while ((n = this.inStr.read()) >= 0) {
            }
        }
        catch (IOException iOException) {
            throw new PSErrorIOError();
        }
        String string = this.inStr.toString();
        if (string.contains("eps2pgf") && string.contains("Decode")) {
            this.closeFile();
        }
    }

    @Override
    public int hashCode() {
        return this.inStr.hashCode();
    }

    @Override
    public String isis() {
        return "-file-";
    }

    public PSObjectString readstring(PSObjectString pSObjectString) throws PSErrorIOError {
        int n;
        int n2 = n = pSObjectString.length();
        try {
            for (int i = 0; i < n; ++i) {
                int n3 = this.inStr.read();
                if (n3 == -1) {
                    n2 = i;
                    break;
                }
                pSObjectString.set(i, (char)n3);
            }
            return pSObjectString.getinterval(0, n2);
        }
        catch (IOException iOException) {
            throw new PSErrorIOError();
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            return null;
        }
    }

    public boolean status() {
        int n;
        try {
            n = this.inStr.available();
        }
        catch (IOException iOException) {
            n = 0;
        }
        return n > 0;
    }

    @Override
    public PSObjectFile toFile() {
        return this;
    }

    @Override
    public List<PSObject> token() throws PSError, ProgramError {
        PSObject pSObject;
        try {
            pSObject = Parser.convertSingle(this.inStr);
        }
        catch (IOException iOException) {
            throw new PSErrorIOError();
        }
        ArrayList<PSObject> arrayList = new ArrayList<PSObject>();
        if (pSObject != null) {
            arrayList.add(pSObject);
            arrayList.add(new PSObjectBool(true));
        } else {
            arrayList.add(new PSObjectBool(false));
        }
        return arrayList;
    }

    @Override
    public String type() {
        return "filetype";
    }

    void setStream(InputStream inputStream) {
        this.inStr = inputStream;
    }

    public InputStream getStream() {
        return this.inStr;
    }
}

