% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_methods.R
\name{summary.clusterlm}
\alias{summary.clusterlm}
\title{Summarize a \code{clusterlm} object.}
\usage{
\method{summary}{clusterlm}(object, alternative = "two.sided", ...)
}
\arguments{
\item{object}{A \code{clusterlm} object.}

\item{alternative}{A character string indicating the alternative hypothesis. Choose between \code{"two.sided"}, \code{"greater"}, \code{"less"}. Default is \code{"two.sided"}.}

\item{...}{Further arguments see details.}
}
\value{
A table for each effect indicating the statistics and p-values of the clusters.
}
\description{
Display the clusters with the corrected p-values for each effects. Results of the \code{"clustermass"} procedure.
}
\details{
If the \code{multcomp} argument is a character string that matches the \code{multcomp} argument of the \code{clusterlm} object, this method returns a matrix with the corrected statistics and p-values in columns and multiple tests by rows.
}
