% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_roc.R
\name{performance_roc}
\alias{performance_roc}
\title{Simple ROC curve}
\usage{
performance_roc(x, ..., predictions, new_data)
}
\arguments{
\item{x}{A numeric vector, representing the outcome (0/1), or a model with
binomial outcome.}

\item{...}{One or more models with binomial outcome. In this case,
\code{new_data} is ignored.}

\item{predictions}{If \code{x} is numeric, a numeric vector of same length
as \code{x}, representing the actual predicted values.}

\item{new_data}{If \code{x} is a model, a data frame that is passed to
\code{predict()} as \code{newdata}-argument. If \code{NULL}, the ROC for
the full model is calculated.}
}
\value{
A data frame with three columns, the x/y-coordinate pairs for the ROC
curve (\code{Sensivity} and \code{Specifity}), and a column with the model
name.
}
\description{
This function calculates a simple ROC curves of x/y coordinates
based on response and predictions of a binomial model.
}
\note{
There is also a \href{https://easystats.github.io/see/articles/performance.html}{\code{plot()}-method} implemented in the \href{https://easystats.github.io/see/}{\pkg{see}-package}.
}
\examples{
library(bayestestR)
data(iris)

set.seed(123)
iris$y <- rbinom(nrow(iris), size = 1, .3)
folds <- sample(nrow(iris), size = nrow(iris) / 8, replace = FALSE)
test_data <- iris[folds, ]
train_data <- iris[-folds, ]

model <- glm(y ~ Sepal.Length + Sepal.Width, data = train_data, family = "binomial")
performance_roc(model, new_data = test_data)

roc <- performance_roc(model, new_data = test_data)
area_under_curve(roc$Specifity, roc$Sensivity)

m1 <- glm(y ~ Sepal.Length + Sepal.Width, data = iris, family = "binomial")
m2 <- glm(y ~ Sepal.Length + Petal.Width, data = iris, family = "binomial")
m3 <- glm(y ~ Sepal.Length + Species, data = iris, family = "binomial")
performance_roc(m1, m2, m3)
}
