% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_aicc.R
\name{performance_aicc}
\alias{performance_aicc}
\title{Compute second order AIC}
\usage{
performance_aicc(x, ...)
}
\arguments{
\item{x}{A model object.}

\item{...}{Currently not used.}
}
\value{
Numeric, the AICc value.
}
\description{
Compute the second-order Akaike's information criterion (AICc).
The second-order (or small sample) is a AIC with a correction for small sample
sizes.
}
\examples{
m <- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
AIC(m)
performance_aicc(m)

}
\references{
\itemize{
\item Akaike, H. (1973) Information theory as an extension of the maximum likelihood principle. In: Second International Symposium on Information Theory, pp. 267–281. Petrov, B.N., Csaki, F., Eds, Akademiai Kiado, Budapest.
\item Hurvich, C. M., Tsai, C.-L. (1991) Bias of the corrected AIC criterion for underfitted regression and time series models. Biometrika 78, 499–509.
}
}
