% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.bayesian.R
\name{model_performance.stanreg}
\alias{model_performance.stanreg}
\title{Performance of Bayesian Models}
\usage{
\method{model_performance}{stanreg}(model, metrics = "all", ...)
}
\arguments{
\item{model}{Object of class \code{stanreg} or \code{brmsfit}.}

\item{metrics}{Can be \code{"all"} or a character vector of metrics to be computed (some of \code{c("LOOIC", "WAIC", "R2", "R2_adj", "RMSE", "LOGLOSS", "SCORE")}).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame (with one row) and one column per "index" (see \code{metrics}).
}
\description{
Compute indices of model performance for (general) linear models.
}
\details{
Depending on \code{model}, following indices are computed:
\itemize{
  \item{\strong{ELPD}} {expected log predictive density, see \code{\link{looic}}}
  \item{\strong{LOOIC}} {leave-one-out cross-validation (LOO) information criterion, see \code{\link{looic}}}
  \item{\strong{WAIC}} {widely applicable information criterion, see \code{loo::waic}}
  \item{\strong{R2}} {r-squared value, see \code{\link{r2}}}
  \item{\strong{R2_LOO_adjusted}} {adjusted r-squared, see \code{\link{r2}}}
  \item{\strong{RMSE}} {root mean squared error, see \code{\link{performance_rmse}}}
  \item{\strong{LOGLOSS}} {Log-loss, see \code{\link{performance_logloss}}}
  \item{\strong{SCORE_LOG}} {score of logarithmic proper scoring rule, see \code{\link{performance_score}}}
  \item{\strong{SCORE_SPHERICAL}} {score of spherical proper scoring rule, see \code{\link{performance_score}}}
  \item{\strong{PCP}} {percentage of correct predictions, see \code{\link{performance_pcp}}}
}
}
\examples{
library(rstanarm)

model <- stan_glm(mpg ~ wt + cyl, data = mtcars, chains = 1, iter = 500)
model_performance(model)

model <- stan_glmer(
  mpg ~ wt + cyl + (1 | gear),
  data = mtcars,
  chains = 1,
  iter = 500
)
model_performance(model)

}
\references{
Gelman, A., Goodrich, B., Gabry, J., & Vehtari, A. (2018). R-squared for Bayesian regression models. The American Statistician, The American Statistician, 1-6.
}
\seealso{
\link{r2_bayes}
}
