% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rse.R
\name{rse}
\alias{rse}
\title{Residual Standard Error for Linear Models}
\usage{
rse(model)
}
\arguments{
\item{model}{Linear model of class \code{lm}, \code{merMod} (\pkg{lme4})
or \code{lme} (\pkg{nlme}).}
}
\value{
Numeric, the residual standard error of \code{model}.
}
\description{
Compute residual standard error of linear models.
}
\details{
The residual standard error is the square root of the residual
  sum of squares divided by the residual degrees of freedom.
}
\examples{
data(mtcars)
m <- lm(mpg ~ hp + gear, data = mtcars)
rse(m)

}
