% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_dend.R
\name{makeDend}
\alias{makeDend}
\title{Recursive partitioning of sequences at a focal point.}
\usage{
makeDend(hapmat, sep = "-")
}
\arguments{
\item{hapmat}{A hapMat object with ordered columns according to the ancestry of SNVs.}

\item{sep}{A separator for haplotype names in the same clade. See the arguments in
\code{\link{reconstructPP}}}
}
\value{
An object of class \code{phylo}.
}
\description{
This function recursively partitions a hapMat object with SNVs ordered by ancestry, and records the
partitioning in a \code{phylo} object.
}
\examples{

\dontshow{

data(ex_hapMatSmall_data)

# First, select a window of SNVs about a focal SNV.
SNV_win <- selectWindow(hapMat = ex_hapMatSmall_data,
                        focalSNV = 10, minWindow = 1)
                        
# Then order SNVs in the window.
ordHapmat <- orderSNVs(snvWin = SNV_win)

# Recursive partitioning of sequences. 
dend <- makeDend(ordHapmat, sep = "-")

}

}
\keyword{internal}
