% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enpy.R
\name{prinsens}
\alias{prinsens}
\title{Principal Sensitivity Components}
\usage{
prinsens(
  x,
  y,
  alpha,
  lambda,
  intercept = TRUE,
  penalty_loadings,
  en_algorithm_opts,
  eps = 1e-06,
  sparse = FALSE,
  ncores = 1L,
  method = deprecated()
)
}
\arguments{
\item{x}{\code{n} by \code{p} matrix of numeric predictors.}

\item{y}{vector of response values of length \code{n}.}

\item{alpha}{elastic net penalty mixing parameter with \eqn{0 \le \alpha \le 1}.
\code{alpha = 1} is the LASSO penalty, and \code{alpha = 0} the Ridge penalty.
Can be a vector of several values, but \code{alpha = 0} cannot be mixed with other values.}

\item{lambda}{optional user-supplied sequence of penalization levels. If given and not \code{NULL},
\code{nlambda} and \code{lambda_min_ratio} are ignored.}

\item{intercept}{include an intercept in the model.}

\item{penalty_loadings}{a vector of positive penalty loadings (a.k.a. weights) for different
penalization of each coefficient. Only allowed for \code{alpha} > 0.}

\item{en_algorithm_opts}{options for the LS-EN algorithm. See \link{en_algorithm_options} for details.}

\item{eps}{numerical tolerance.}

\item{sparse}{use sparse coefficient vectors.}

\item{ncores}{number of CPU cores to use in parallel. By default, only one CPU core is used.
Not supported on all platforms, in which case a warning is given.}

\item{method}{defunct. PSCs are always computed for EN estimates. For the PY procedure for unpenalized estimation
use package \href{https://cran.r-project.org/package=pyinit}{pyinit}.}
}
\value{
a list of principal sensitivity components, one per element in \code{lambda}. Each PSC is itself a list
with items \code{lambda}, \code{alpha}, and \code{pscs}.
}
\description{
Compute Principal Sensitivity Components for Elastic Net Regression
}
\references{
Cohen Freue, G.V.; Kepplinger, D.; Salibián-Barrera, M.; Smucler, E.
Robust elastic net estimators for variable selection and identification of proteomic biomarkers.
\emph{Ann. Appl. Stat.} \strong{13} (2019), no. 4, 2065--2090 \doi{10.1214/19-AOAS1269}

Pena, D., and Yohai, V.J.
A Fast Procedure for Outlier Diagnostics in Large Regression Problems.
\emph{J. Amer. Statist. Assoc.} \strong{94} (1999). no. 446, 434--445. \doi{10.2307/2670164}
}
\seealso{
Other functions for initial estimates: 
\code{\link{enpy_initial_estimates}()},
\code{\link{starting_point}()}
}
\concept{functions for initial estimates}
