% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{mloc}
\alias{mloc}
\title{Compute the M-estimate of Location}
\usage{
mloc(x, scale, rho, cc, opts = mscale_algorithm_options())
}
\arguments{
\item{x}{numeric values. Missing values are verbosely ignored.}

\item{scale}{scale of the \code{x} values. If omitted, uses the \link[stats:mad]{mad()}.}

\item{rho}{the \eqn{\rho} function to use. See \code{\link[=rho_function]{rho_function()}} for available functions.}

\item{cc}{value of the tuning constant for the chosen \eqn{\rho} function.
By default, chosen to achieve 95\% efficiency under the Normal distribution.}

\item{opts}{a list of options for the M-estimating algorithm, see
\code{\link[=mscale_algorithm_options]{mscale_algorithm_options()}} for details.}
}
\value{
a single numeric value, the M-estimate of location.
}
\description{
Compute the M-estimate of location using an auxiliary estimate of the scale.
}
\seealso{
Other functions to compute robust estimates of location and scale: 
\code{\link{mlocscale}()},
\code{\link{mscale}()},
\code{\link{tau_size}()}
}
\concept{functions to compute robust estimates of location and scale}
