% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdfeppml_int.R
\name{hdfeppml_int}
\alias{hdfeppml_int}
\title{PPML Estimation with HDFE}
\usage{
hdfeppml_int(
  y,
  x = NULL,
  fes = NULL,
  tol = 1e-08,
  hdfetol = 1e-04,
  colcheck_x = TRUE,
  colcheck_x_fes = TRUE,
  mu = NULL,
  saveX = TRUE,
  init_z = NULL,
  verbose = FALSE,
  maxiter = 1000,
  cluster = NULL,
  vcv = TRUE
)
}
\arguments{
\item{y}{Dependent variable (a vector)}

\item{x}{Regressor matrix.}

\item{fes}{List of fixed effects.}

\item{tol}{Tolerance parameter for convergence of the IRLS algorithm.}

\item{hdfetol}{Tolerance parameter for the within-transformation step,
passed on to \code{collapse::fhdwithin}.}

\item{colcheck_x}{Logical. If \code{TRUE}, this checks collinearity between the independent variables and drops the
collinear variables.}

\item{colcheck_x_fes}{Logical. If \code{TRUE}, this checks whether the independent variables are perfectly explained
by the fixed effects drops those that are perfectly explained.}

\item{mu}{A vector of initial values for mu that can be passed to the command.}

\item{saveX}{Logical. If \code{TRUE}, it returns the values of x and z after partialling out the
fixed effects.}

\item{init_z}{Optional: initial values of the transformed dependent variable, to be used in the
first iteration of the algorithm.}

\item{verbose}{Logical. If \code{TRUE}, it prints information to the screen while evaluating.}

\item{maxiter}{Maximum number of iterations (a number).}

\item{cluster}{Optional: a vector classifying observations into clusters (to use when calculating SEs).}

\item{vcv}{Logical. If \code{TRUE} (the default), it returns standard errors.}
}
\value{
A list with the following elements:
\itemize{
\item \code{coefficients}: a 1 x \code{ncol(x)} matrix with coefficient (beta) estimates.
\item \code{residuals}: a 1 x \code{length(y)} matrix with the residuals of the model.
\item \code{mu}: a 1 x \code{length(y)} matrix with the final values of the conditional mean \eqn{\mu}.
\item \code{deviance}:
\item \code{bic}: Bayesian Information Criterion.
\item \code{x_resid}: matrix of demeaned regressors.
\item \code{z_resid}: vector of demeaned (transformed) dependent variable.
\item \code{se}: standard errors of the coefficients.
}
}
\description{
\code{hdfeppml_int} is the internal algorithm called by \code{hdfeppml} to fit an (unpenalized)
Poisson Pseudo Maximum Likelihood (PPML) regression with high-dimensional fixed effects (HDFE). It
takes a vector with the dependent variable, a regressor matrix and a set of fixed effects (in list
form: each element in the list should be a separate HDFE).
}
\details{
More formally, \code{hdfeppml_int} performs iteratively re-weighted least squares (IRLS) on a
transformed model, as described in Correia, Guimarães and Zylkin (2020) and similar to the
\code{ppmlhdfe} package in Stata. In each iteration, the function calculates the transformed dependent
variable, partials out the fixed effects (calling \code{collapse::fhdwithin}, which uses the algorithm in
Gaure (2013)) and then solves a weighted least squares problem (using fast C++ implementation).
}
\section{References}{

Breinlich, H., Corradi, V., Rocha, N., Ruta, M., Santos Silva, J.M.C. and T. Zylkin (2021).
"Machine Learning in International Trade Research: Evaluating the Impact of Trade Agreements",
Policy Research Working Paper; No. 9629. World Bank, Washington, DC.

Correia, S., P. Guimaraes and T. Zylkin (2020). "Fast Poisson estimation with high dimensional
fixed effects", \emph{STATA Journal}, 20, 90-115.

Gaure, S (2013). "OLS with multiple high dimensional category variables",
\emph{Computational Statistics & Data Analysis}, 66, 8-18.

Friedman, J., T. Hastie, and R. Tibshirani (2010). "Regularization paths for generalized linear
models via coordinate descent", \emph{Journal of Statistical Software}, 33, 1-22.

Belloni, A., V. Chernozhukov, C. Hansen and D. Kozbur (2016). "Inference in high dimensional panel
models with an application to gun control", \emph{Journal of Business & Economic Statistics}, 34, 590-605.
}

\examples{
# To reduce run time, we keep only countries in the Americas:
americas <- countries$iso[countries$region == "Americas"]
trade <- trade[(trade$imp \%in\% americas) & (trade$exp \%in\% americas), ]
# Now generate the needed x, y and fes objects:
y <- trade$export
x <- data.matrix(trade[, -1:-6])
fes <- list(exp_time = interaction(trade$exp, trade$time),
            imp_time = interaction(trade$imp, trade$time),
            pair     = interaction(trade$exp, trade$imp))
# Finally, the call to hdfeppml_int:
reg <- hdfeppml_int(y = y, x = x, fes = fes)

}
