% Generated by roxygen2 (4.0.2): do not edit by hand
\name{spJitterFinite}
\alias{spJitterFinite}
\title{Random perturbation of spatial points}
\usage{
spJitterFinite(points, candidates, x.max, x.min, y.max, y.min, which.point)
}
\arguments{
\item{points}{data.frame or matrix with three columns: 1) the identification
of each point, 2) the x coordinates of the set of points, and 3) the y
coordinates of the set of points. The coordinates must be projected. This is
the set of points to be optimized. \code{points} must be a subset of
\code{candidates}. See \sQuote{Details} for more information.}

\item{candidates}{data.frame or matrix with the candidate locations for the
sample points. See \sQuote{Details} for more information.}

\item{x.max,x.min,y.max,y.min}{The minimum and maximum quantity of random
noise to be added to the x and y coordinates. The minimum quantity should be
equal to, at least, the minimum distance between two neighboring candidate
locations. The units are the same as of the coordinates. See \sQuote{Details}
for more information.}

\item{which.point}{Integer values defining which point should be perturbed.
The current version accepts only one point to be perturbed at a time. See
\sQuote{Details} for more information.}
}
\value{
A matrix with the jittered coordinates of the points.
}
\description{
This function perturbs the coordinates of spatial points. This is also known
as \sQuote{jittering}.
}
\details{
This function perturbs the coordinates of spatial points adding random noise,
a process also known as \sQuote{jittering}. There are two ways of jittering
the coordinates. They differ on how the the set of candidate locations is
defined.

\subsection{Finite set of candidate locations}{
The first method uses a finite set of candidate locations for the perturbed
points. This method usually is the fastest because it does not require the
use of complex routines to check if the perturbed point falls inside the
spatial domain. Since the candidate locations is a finite set, any perturbed
point will inexorably fall inside the spatial domain. This is a very
important feature in optimization exercises with complex objective functions
such as simulated annealing when repetitive perturbation is required.

The arguments \code{x.min}, \code{y.min}, \code{x.max}, and \code{y.max} are
used to define a rectangular window containing the set of effective candidate
locations for the point defined with the argument \code{which.point}. The new
location is then randomly sampled from the set of effective candidate
locations and checked against existing points to avoid duplicates. The
current implementation does not enable to define the direction of the
perturbation, nor to perturb more than one point at a time.
}
\subsection{Infinite set of candidate locations}{
The current version does not accept using an infinite set of candidate
locations.
}
}
\note{
This function is under construction! The current version does not accept
using an infinite set of candidate locations or to perturb
more than one point at a time.

Some of the solutions used to build this function were found in the source
code of the R-package \strong{intamapInteractive}. As such, the authors of
that package, Edzer Pebesma <\email{edzer.pebesma@uni-muenster.de}> and Jon
Skoien <\email{jon.skoien@gmail.com}>, are entitled \sQuote{contributors} to
the R-package \pkg{pedometrics}.
}
\examples{
require(sp)
data(meuse.grid)
meuse.grid <- as.matrix(meuse.grid[, 1:2])
meuse.grid <- matrix(cbind(1:dim(meuse.grid)[1], meuse.grid), ncol = 3)
pts1 <- sample(c(1:dim(meuse.grid)[1]), 155)
pts2 <- meuse.grid[pts1, ]
pts3 <- spJitterFinite(points = pts2, candidates = meuse.grid, x.min = 40,
                      x.max = 100, y.min = 40, y.max = 100, which.point = 10)
plot(meuse.grid[, 2:3], asp = 1, pch = 15, col = "gray")
points(pts2[, 2:3], col = "red", cex = 0.5)
points(pts3[, 2:3], pch = 19, col = "blue", cex = 0.5)
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}

Gerard Heuvelink \email{gerard.heuvelink@wur.nl}
}
\references{
Edzer Pebesma, Jon Skoien with contributions from Olivier Baume, A. Chorti,
D.T. Hristopulos, S.J. Melles and G. Spiliopoulos (2013).
\emph{intamapInteractive: procedures for automated interpolation - methods
only to be used interactively, not included in intamap package.} R package
version 1.1-10. \url{http://CRAN.R-project.org/package=intamapInteractive}

Van Groenigen, J.-W. \emph{Constrained optimization of spatial sampling:
a geostatistical approach.} Wageningen: Wageningen University, p. 148, 1999.
}
\seealso{
\code{ssaOptim}, \code{\link[sp]{zerodist}},
\code{\link[base]{jitter}}, \code{\link[geoR]{jitter2d}},
\code{\link[rgeos]{gContains}}.
}
\concept{
jitter perturb
}
\keyword{iteration}
\keyword{spatial}

