% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_properties.R
\name{findStationary}
\alias{findStationary}
\title{Find the stationary frequency distribution}
\usage{
findStationary(mutmat)
}
\arguments{
\item{mutmat}{A mutation matrix.}
}
\value{
A vector of length \code{ncol(mutmat)}, or NULL.
}
\description{
Finds the stationary distribution of allele frequencies, if it exists, w.r.t. a given mutation matrix.
}
\examples{

m1 = mutationMatrix("equal", alleles = 1:4, rate = 0.1)
findStationary(m1)

m2 = mutationMatrix("random", alleles = 1:3, seed = 123)
a = findStationary(m2)

a \%*\% m2 - a  # check

}
