% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examples.R
\name{rExamples2D}
\alias{rExamples2D}
\title{Several example time-varying spectral matrices}
\usage{
rExamples2D(n, d = 3, B, example = c("smiley", "tvar", "peak", "facets"),
  bias.corr = F, ...)
}
\arguments{
\item{n}{numeric vector with two components corresponding to the size of the discretized time-frequency grid at which the spectral matrix
is generated.}

\item{d}{row- (resp. column-)dimension of the generated spectral matrix.}

\item{B}{complex Wishart distribution degrees of freedom, defaults to \code{B = d}, such that the generated pseudo periodogram matrix
observations are positive definite. Note that \code{B} coincides with the number of tapering functions in the (time-varying) multitaper
periodogram in \code{\link{pdPgram2D}}.}

\item{example}{the example spectral matrix, one of \code{'smiley'}, \code{'tvar'}, \code{'peak'} or \code{'facets'}.}

\item{bias.corr}{should the Riemannian manifold bias-correction be applied to the HPD periodogram matrix?
Defaults to \code{FALSE}.}

\item{...}{additional arguments for internal use.}
}
\value{
Returns a list with two components:
   \item{\code{f} }{ example spectral matrix, \code{f} is a \code{(d, d, n[1], n[2])}-dimensional array, corresponding
   to a \eqn{(d \times d)}-dimensional spectral matrix at a \eqn{(n_1,n_2)}-dimensional grid of time-frequency points.}
   \item{\code{tf.grid} }{ a list with two components \code{tf.grid$time} and \code{tf.grid$frequency} specifying the
   rectangular grid of time-frequency points at which the spectral matrix is generated. \code{tf.grid$time}
   is a numeric vector of rescaled time points in \code{(0,1]}. \code{tf.grid$frequency} is a numeric
   vector of frequency points in \code{(0,0.5]}, with 0.5 corresponding to the Nyquist frequency.}
   \item{\code{per} }{ pseudo HPD periodogram observations generated as random complex Wishart matrices centered around \code{f}
   with \code{B} degrees of freedom at \eqn{(n_1,n_2)}-dimensional grid of time-frequency points.}
}
\description{
\code{rExamples2D()} generates several example HPD time-varying spectral matrices for testing and simulation purposes.
}
\details{
The examples include: (i) a \eqn{(d \times d)} smiley HPD spectral matrix consisting of constant surfaces of random HPD matrices in
the shape of a smiley face, (ii) a \eqn{(d \times d)} tvar HPD spectral matrix generated from a time-varying vector auto-
regressive process of order 1 with a random time-varying coefficient matrix (\eqn{\Phi}), (iii) a \eqn{(d \times d)} generally smooth
HPD spectral matrix containing a pronounced peak in the center of the discretized time-frequency grid and (iv) a \eqn{(d \times d)}
facets HPD spectral matrix consisting of several facets generated from random geodesic surfaces. In addition to the HPD spectral matrices,
the function also generates pseudo HPD periodogram observations as independent complex random HPD Wishart matrices centered around
the generating HPD spectral matrix with \eqn{B} degrees of freedom. Informally, such random matrix behavior corresponds to the asymptotic
distribution of actual HPD periodogram observations (as obtained via \code{\link{pdPgram2D}}) of a multivariate time series with the given
generating HPD spectral matrix.
}
\examples{
example <- rExamples2D(n = c(2^5, 2^5), example = "smiley")

}
\references{
Chau, J. and von Sachs, R. (2017). \emph{Positive definite multivariate spectral
estimation: a geometric wavelet approach}. Available at \url{http://arxiv.org/abs/1701.03314}.
}
\seealso{
\code{\link{pdPgram2D}}
}
