% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rarefy.R
\name{rare_curve_species}
\alias{rare_curve_species}
\title{Rare the species}
\usage{
rare_curve_species(
  otutab,
  step = 2000,
  method = "richness",
  mode = 2,
  reps = 3,
  threads = 1,
  verbose = TRUE
)
}
\arguments{
\item{otutab}{otutab}

\item{step}{default 2000}

\item{method}{one of "richness","chao1","ace","gc","shannon","simpson","pd","pielou"}

\item{mode}{1 for little table, 2 for big}

\item{reps}{reps}

\item{threads}{use how many threads to calculate (default:1)}

\item{verbose}{verbose}
}
\value{
ggplot
}
\description{
Rare the species
}
\examples{
data(otutab, package = "pcutils")
a <- rare_curve_species(otutab, mode = 1)
plot(a)
}
