% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{rel.verts.tri.nd}
\alias{rel.verts.tri.nd}
\title{The indices of the vertex regions in a triangle that contains the points in a give data set}
\usage{
rel.verts.tri.nd(Xp, tri, r, cent = 1)
}
\arguments{
\item{Xp}{A set of 2D points representing the set of data points for which indices of the vertex regions
containing them are to be determined.}

\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be in \eqn{(1,1.5]} for this function.}

\item{cent}{Index of the center (as \eqn{1,2,3} corresponding to \eqn{M_1,\,M_2,\,M_3}) which gives nondegenerate asymptotic
distribution of the domination number of PE-PCD for uniform data in \code{tri} for expansion parameter \code{r} in \eqn{(1,1.5]};
default \code{cent=1}.}
}
\value{
A \code{list} with two elements
\item{rv}{Indices (i.e., a \code{vector} of indices) of the vertices whose region contains points in \code{Xp}
in the triangle \code{tri}}
\item{tri}{The vertices of the triangle, where row number corresponds to the vertex index in \code{rv}.}
}
\description{
Returns the indices of the vertices whose regions contain the points in data set \code{Xp} in
a triangle \code{tri}\eqn{=(A,B,C)} and vertex regions are based on the center \code{cent} which yields nondegenerate asymptotic
distribution of the domination number of PE-PCD for uniform data in \code{tri} for expansion parameter \code{r} in \eqn{(1,1.5]}.

Vertices of triangle \code{tri} are labeled as \eqn{1,2,3} according to the row number the vertex is recorded
if a point in \code{Xp} is not inside \code{tri}, then the function yields \code{NA} as output for that entry.
The corresponding vertex region is the polygon with the vertex, \code{cent}, and projection points on the edges.
The center label \code{cent} values \code{1,2,3} correspond to the vertices \eqn{M_1}, \eqn{M_2}, and \eqn{M_3}; with default 1
(see the examples for an illustration).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:dom-num-NPE-Spat2011,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
r<-1.35
cent<-2

P<-c(1.4,1.0)
rel.verts.tri.nd(P,Tr,r,cent)

n<-20  #try also n<-40
set.seed(1)
Xp<-runif.tri(n,Tr)$g

rel.verts.tri.nd(Xp,Tr,r,cent)
rel.verts.tri.nd(rbind(Xp,c(2,2)),Tr,r,cent)

rv<-rel.verts.tri.nd(Xp,Tr,r,cent)

M<-cent.nondegPE(Tr,r)[cent,];
Ds<-cent.ndPE2edges(Tr,r,cent)

Xlim<-range(Tr[,1],Xp[,1])
Ylim<-range(Tr[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,pch=".",xlab="",ylab="",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(Xp,pch=".",col=1)
L<-rbind(M,M,M); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

xc<-Tr[,1]+c(-.03,.05,.05)
yc<-Tr[,2]+c(-.06,.02,.05)
txt.str<-c("rv=1","rv=2","rv=3")
text(xc,yc,txt.str)

txt<-rbind(M,Ds)
xc<-txt[,1]+c(.02,.04,-.03,0)
yc<-txt[,2]+c(.07,.03,.05,-.07)
txt.str<-c("M","D1","D2","D3")
text(xc,yc,txt.str)
text(Xp,labels=factor(rv$rv))
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rel.verts.triCM}}, \code{\link{rel.verts.triCC}} and \code{\link{rel.verts.tri.cent}}
}
\author{
Elvan Ceyhan
}
