% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{NumArcsPEint}
\alias{NumArcsPEint}
\title{Number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs) - one interval case}
\usage{
NumArcsPEint(Xp, int, r, c = 0.5)
}
\arguments{
\item{Xp}{A set of 1D points which constitute the vertices of PE-PCD.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int}\eqn{=(a,b)}
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
A \code{list} with the elements
\item{num.arcs}{Total number of arcs in all intervals (including the end intervals),
i.e., the number of arcs for the entire PE-PCD}
\item{num.in.range}{Number of \code{Xp} points in the interval \code{int}}
\item{num.in.ints}{The vector of number of \code{Xp} points in the partition intervals (including the end intervals)}
\item{int.num.arcs}{The \code{vector} of the number of arcs of the component of the PE-PCD in the
partition intervals (including the end intervals)}
\item{data.int.ind}{A \code{vector} of indices of partition intervals in which data points reside.
Partition intervals are numbered from left to right with 1 being the left end interval.}
}
\description{
Returns the number of arcs and various other quantities, vectors, and lists for Proportional Edge Proximity Catch Digraph
(PE-PCD) whose vertices are the data points in \code{Xp} in the one middle interval case.

The data points could be inside or outside the interval is \code{int}\eqn{=(a,b)}. PE proximity region is constructed
with an expansion parameter \eqn{r \ge 1} and a centrality parameter \eqn{c \in (0,1)}.
\code{int} determines the end points of the interval.

The PE proximity region is constructed for both points inside and outside the interval, hence
the arcs may exist for all points inside or outside the interval.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
\dontrun{
c<-.4
r<-2
a<-0; b<-10; int<-c(a,b)

xf<-(int[2]-int[1])*.1

set.seed(123)

n<-10
Xp<-runif(n,a-xf,b+xf)
NumArcsPEint(Xp,int,r,c)
NumArcsPEint(Xp,int,r,c=.3)
NumArcsPEint(Xp,int,r=1.5,c)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsPEmid.int}}, \code{\link{NumArcsPEend.int}}, and \code{\link{NumArcsCSint}}
}
\author{
Elvan Ceyhan
}
