% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{plotCSregsMI}
\alias{plotCSregsMI}
\title{The plot of the Central Similarity (CS) Proximity Regions (vertices jittered along y-coordinate)
- multiple interval case}
\usage{
plotCSregsMI(
  Xp,
  Yp,
  t,
  c,
  Jit = 0.1,
  main = "",
  xlab = "",
  ylab = "",
  xlim = NULL,
  ylim = NULL,
  centers = FALSE,
  ...
)
}
\arguments{
\item{Xp}{A set of 1D points for which CS proximity regions are plotted.}

\item{Yp}{A set of 1D points which constitute the end points of the intervals which
partition the real line.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \eqn{int=(a,b)}.
For the interval, \eqn{int=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}; default=0.5.}

\item{Jit}{A positive real number that determines the amount of jitter along the y-axis, default is 0.1 and
\code{Xp} points are jittered according to \eqn{U(-Jit,Jit)} distribution along the y-axis where \code{Jit} equals to the range of \code{Xp} and \code{Yp} and the
proximity regions (intervals) multiplied by \code{Jit}).}

\item{main}{An overall title for the plot (default="").}

\item{xlab, ylab}{Titles for the x and y axes, respectively (default="" for both).}

\item{xlim, ylim}{Numeric vectors of length 2, giving the x- and y-coordinate ranges
(default=\code{NULL} for both).}

\item{centers}{A logical argument, if \code{TRUE}, plot includes the centers of the intervals
as vertical lines in the plot, else centers of the intervals are not plotted.}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
Plot of the CS proximity regions for 1D points located in the middle or end intervals
based on \code{Yp} points
}
\description{
Plots the points in and outside of the intervals based on \code{Yp} points and also the CS proximity regions
(which are also intervals).

CS proximity region is constructed with expansion parameter \eqn{t>0} and
centrality parameter \code{c} in \eqn{(0,1)}. For better visualization, a uniform jitter from \eqn{U(-Jit,Jit)}
(default for \eqn{Jit=.1} times range of \code{Xp} and \code{Yp} and the proximity regions (intervals)) is added to the
y-direction.

\code{centers} is a logical argument, if \code{TRUE},
plot includes the centers of the intervals as vertical lines in the plot,
else centers of the intervals are not plotted.

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
t<-2
c<-.4
a<-0; b<-10;

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
xr<-range(a,b)
xf<-(xr[2]-xr[1])*.1

Xp<-runif(nx,a-xf,b+xf)
Yp<-runif(ny,a,b)

plotCSregsMI(Xp,Yp,t,c,xlab="",ylab="")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotCSregsInt}} and \code{\link{plotPEregsMI}}
}
