% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceUGFunctions.R
\name{plotASedges}
\alias{plotASedges}
\title{The plot of the edges of the underlying or reflexivity graph of
the Arc Slice Proximity Catch Digraph
(AS-PCD) for 2D data - multiple triangle case}
\usage{
plotASedges(
  Xp,
  Yp,
  M = "CC",
  ugraph = c("underlying", "reflexivity"),
  asp = NA,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the underlying
or reflexivity graphs of the AS-PCD.}

\item{Yp}{A set of 2D points
which constitute the vertices of the Delaunay triangles.}

\item{M}{The center of the triangle.
\code{"CC"} stands for circumcenter of each Delaunay triangle
or 3D point in barycentric coordinates
which serves as a center in the interior of each Delaunay triangle;
default is \code{M="CC"}, i.e., the circumcenter of each triangle.}

\item{ugraph}{The type of the graph based on AS-PCDs,
\code{"underlying"} is for the underlying graph,
and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}

\item{asp}{A \code{numeric} value,
giving the aspect ratio \eqn{y/x} (default is \code{NA}),
see the official help page for \code{asp} by typing "\code{? asp}".}

\item{main}{An overall title for the plot (default=\code{NULL}).}

\item{xlab, ylab}{Titles for the \eqn{x} and \eqn{y} axes,
respectively (default=\code{NULL} for both).}

\item{xlim, ylim}{Two \code{numeric} vectors of length 2,
giving the \eqn{x}- and \eqn{y}-coordinate ranges
(default=\code{NULL} for both).}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
A plot of the edges of the underlying
or reflexivity graphs of the AS-PCD for a 2D data set \code{Xp}
where AS proximity regions
are defined with respect to the Delaunay triangles based on \code{Yp} points;
also plots the Delaunay triangles
based on \code{Yp} points.
}
\description{
Plots the edges of the underlying or reflexivity graph of
the Arc Slice Proximity Catch Digraph
(AS-PCD) whose vertices are the data
points in \code{Xp} in the multiple triangle case
and the Delaunay triangles based on \code{Yp} points.

AS proximity regions are constructed
with respect to the Delaunay triangles based on \code{Yp} points, i.e.,
AS proximity regions are defined only for \code{Xp} points
inside the convex hull of \code{Yp} points.
That is, edges may exist for \code{Xp} points
only inside the convex hull of \code{Yp} points.

Vertex regions are based on the center \code{M="CC"}
for circumcenter of each Delaunay triangle
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of each Delaunay triangle;
default is \code{M="CC"}, i.e., circumcenter of each triangle.
When the center is the circumcenter, \code{CC},
the vertex regions are constructed based on the
orthogonal projections to the edges,
while with any interior center \code{M},
the vertex regions are constructed using the extensions
of the lines combining vertices with \code{M}.

Convex hull of \code{Yp} is partitioned by
the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles
whose union constitutes the
convex hull of \code{Yp} points).
Loops are not allowed so edges are only possible
for points inside the convex hull of \code{Yp} points.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:stamet2016;textual}{pcds.ugraph})
for more on the AS-PCDs.
Also, see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds.ugraph})
for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
#\donttest{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-5;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),
runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))

M<-c(1,1,1)

plotASedges(Xp,Yp,M,xlab="",ylab="")
plotASedges(Xp,Yp,M,xlab="",ylab="",ugraph="r")
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotASedges.tri}}, \code{\link{plotPEedges}},
\code{\link{plotCSedges}}, and \code{\link[pcds]{plotASarcs}}
}
\author{
Elvan Ceyhan
}
