% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/222_export_opt.r
\name{Control Functions}
\alias{.zmqopt_get}
\alias{.zmqopt_init}
\alias{.zmqopt_set}
\alias{Control Functions}
\title{Set controls in pbdZMQ}
\usage{
.zmqopt_get(main, sub = NULL, envir = .GlobalEnv)

.zmqopt_set(val, main, sub = NULL, envir = .GlobalEnv)

.zmqopt_init(envir = .GlobalEnv)
}
\arguments{
\item{main}{a ZMQ control variable}

\item{sub}{a ZMQ control sub-variable}

\item{envir}{an environment where ZMQ controls locate}

\item{val}{a value for the ZMQ control}
}
\value{
\code{.zmqopt_get()} returns the value of the ZMQ control.

\code{.zmqopt_set()} sets the value to the ZMQ control.

\code{.zmqopt_init()} initial the ZMQ control to \code{\link{.pbd_env}}
at \code{envir}.
}
\description{
Control functions
}
\details{
\code{.zmqopt_get()} gets a ZMQ control.

\code{.zmqopt_set()} sets a ZMQ control.

\code{.zmqopt_init()} initials default ZMQ controls.
}
\examples{
\dontrun{
library(pbdZMQ, quietly = TRUE)

ls(.pbd_env)
rm(.pbd_env)
.zmqopt_init()
ls(.pbd_env)

.pbd_env$ZMQ.SR$BLOCK
.zmqopt_set(0L, "ZMQ.SR", "BLOCK")
}

}
\author{
Wei-Chen Chen \email{wccsnow@gmail.com}.
}
\references{
ZeroMQ/4.1.0 API Reference:
\url{http://api.zeromq.org/4-1:_start}

Programming with Big Data in R Website: \url{http://r-pbd.org/}
}
\seealso{
\code{\link{.pbd_env}}.
}
\keyword{programming}

