% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_eigen.r
\docType{methods}
\name{ddmatrix-eigen}
\alias{ddmatrix-eigen}
\alias{eigen}
\alias{eigen,ddmatrix-method}
\title{eigen}
\usage{
\S4method{eigen}{ddmatrix}(x, symmetric, only.values = FALSE,
  EISPACK = FALSE)
}
\arguments{
\item{x}{numeric distributed matrices.}

\item{symmetric}{logical, if \code{TRUE} then the matrix is assumed to be
symmetric and only the lower triangle is used.  Otherwise \code{x} is
inspected for symmetry.}

\item{only.values}{logical, if \code{TRUE} then only the eigenvalues are
returned.  Otherwise both eigenvalues and eigenvectors are returned.}

\item{EISPACK}{Ignored.}
}
\value{
\code{eigen()} computes the eigenvalues, and eigenvectors if requested.  As
}
\description{
Eigenvalue decomposition for distributed matrices with R-like syntax, with
calculations performed by the PBLAS and ScaLAPACK libraries.
}
\details{
Extensions of R linear algebra functions.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

x <- ddmatrix(1:9, 3, bldim=2)

y <- eigen(crossprod(x))
y

finalize()
}

}
\keyword{Algebra}
\keyword{Linear}
\keyword{Methods}

