% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_cov.R
\docType{methods}
\name{covariance}
\alias{cor,ddmatrix-method}
\alias{cov,ddmatrix-method}
\alias{cov2cor,ddmatrix-method}
\alias{covariance}
\alias{var,ddmatrix-method}
\title{Covariance and Correlation}
\usage{
\S4method{cov}{ddmatrix}(x, y = NULL, use = "everything",
  method = "pearson")

\S4method{var}{ddmatrix}(x, y = NULL, na.rm = FALSE, use)

\S4method{cor}{ddmatrix}(x, y = NULL, use = "everything",
  method = "pearson")

\S4method{cov2cor}{ddmatrix}(V)
}
\arguments{
\item{x, y, V}{numeric distributed matrices.}

\item{use}{character indicating how missing values should be treated.
Acceptable values are the same as \code{R}'s, namely "everything",
"all.obs", "complete.obs", "na.or.complete", or "pairwise.complete.obs".}

\item{method}{character argument indicating which method should be used to
calculate covariances. Currently only "spearman" is available for
\code{ddmatrix}.}

\item{na.rm}{logical, determines whether or not \code{NA}'s should be dealth
with.}
}
\value{
Returns a distributed matrix.
}
\description{
\code{cov()}
and \code{var()} form the variance-covariance matrix.  \code{cor()} forms
the correlation matrix.  \code{cov2cor()} scales a covariance matrix into a
correlation matrix.
}
\details{
\code{cov()} forms the variance-covariance matrix. Only
\code{method="pearson"} is implemented at this time.

\code{var()} is a shallow wrapper for \code{cov()} in the case of a
distributed matrix.

\code{cov2cor()} scales a covariance matrix into a correlation matrix.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

x <- ddmatrix("rnorm", nrow=3, ncol=3), bldim=2

cv <- cov(x)
print(cv)

finalize()
}

}
\keyword{Methods}

