% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{proton}
\alias{proton}
\title{AWS Proton}
\usage{
proton(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
This is the Proton Service API Reference. It provides descriptions,
syntax and usage examples for each of the
\href{https://docs.aws.amazon.com/proton/latest/APIReference/API_Operations.html}{actions}
and \href{https://docs.aws.amazon.com/proton/latest/APIReference/API_Types.html}{data types}
for the Proton service.

The documentation for each action shows the Query API request parameters
and the XML response.

Alternatively, you can use the Amazon Web Services CLI to access an API.
For more information, see the \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-welcome.html}{Amazon Web Services Command Line Interface User Guide}.

The Proton service is a two-pronged automation framework. Administrators
create service templates to provide standardized infrastructure and
deployment tooling for serverless and container based applications.
Developers, in turn, select from the available service templates to
automate their application or service deployments.

Because administrators define the infrastructure and tooling that Proton
deploys and manages, they need permissions to use all of the listed API
operations.

When developers select a specific infrastructure and tooling set, Proton
deploys their applications. To monitor their applications that are
running on Proton, developers need permissions to the service \emph{create},
\emph{list}, \emph{update} and \emph{delete} API operations and the service instance
\emph{list} and \emph{update} API operations.

To learn more about Proton, see the \href{https://docs.aws.amazon.com/proton/latest/userguide/Welcome.html}{Proton User Guide}.

\strong{Ensuring Idempotency}

When you make a mutating API request, the request typically returns a
result before the asynchronous workflows of the operation are complete.
Operations might also time out or encounter other server issues before
they're complete, even if the request already returned a result. This
might make it difficult to determine whether the request succeeded.
Moreover, you might need to retry the request multiple times to ensure
that the operation completes successfully. However, if the original
request and the subsequent retries are successful, the operation occurs
multiple times. This means that you might create more resources than you
intended.

\emph{Idempotency} ensures that an API request action completes no more than
one time. With an idempotent request, if the original request action
completes successfully, any subsequent retries complete successfully
without performing any further actions. However, the result might
contain updated information, such as the current creation status.

The following lists of APIs are grouped according to methods that ensure
idempotency.

\strong{Idempotent create APIs with a client token}

The API actions in this list support idempotency with the use of a
\emph{client token}. The corresponding Amazon Web Services CLI commands also
support idempotency using a client token. A client token is a unique,
case-sensitive string of up to 64 ASCII characters. To make an
idempotent API request using one of these actions, specify a client
token in the request. We recommend that you \emph{don't} reuse the same
client token for other API requests. If you don’t provide a client token
for these APIs, a default client token is automatically provided by
SDKs.

Given a request action that has succeeded:

If you retry the request using the same client token and the same
parameters, the retry succeeds without performing any further actions
other than returning the original resource detail data in the response.

If you retry the request using the same client token, but one or more of
the parameters are different, the retry throws a \code{ValidationException}
with an \code{IdempotentParameterMismatch} error.

Client tokens expire eight hours after a request is made. If you retry
the request with the expired token, a new resource is created.

If the original resource is deleted and you retry the request, a new
resource is created.

Idempotent create APIs with a client token:
\itemize{
\item CreateEnvironmentTemplateVersion
\item CreateServiceTemplateVersion
\item CreateEnvironmentAccountConnection
}

\strong{Idempotent create APIs}

Given a request action that has succeeded:

If you retry the request with an API from this group, and the original
resource \emph{hasn't} been modified, the retry succeeds without performing
any further actions other than returning the original resource detail
data in the response.

If the original resource has been modified, the retry throws a
\code{ConflictException}.

If you retry with different input parameters, the retry throws a
\code{ValidationException} with an \code{IdempotentParameterMismatch} error.

Idempotent create APIs:
\itemize{
\item CreateEnvironmentTemplate
\item CreateServiceTemplate
\item CreateEnvironment
\item CreateService
}

\strong{Idempotent delete APIs}

Given a request action that has succeeded:

When you retry the request with an API from this group and the resource
was deleted, its metadata is returned in the response.

If you retry and the resource doesn't exist, the response is empty.

In both cases, the retry succeeds.

Idempotent delete APIs:
\itemize{
\item DeleteEnvironmentTemplate
\item DeleteEnvironmentTemplateVersion
\item DeleteServiceTemplate
\item DeleteServiceTemplateVersion
\item DeleteEnvironmentAccountConnection
}

\strong{Asynchronous idempotent delete APIs}

Given a request action that has succeeded:

If you retry the request with an API from this group, if the original
request delete operation status is \code{DELETE_IN_PROGRESS}, the retry
returns the resource detail data in the response without performing any
further actions.

If the original request delete operation is complete, a retry returns an
empty response.

Asynchronous idempotent delete APIs:
\itemize{
\item DeleteEnvironment
\item DeleteService
}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- proton(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.compute:proton_accept_environment_account_connection]{accept_environment_account_connection} \tab In a management account, an environment account connection request is accepted\cr
\link[paws.compute:proton_cancel_component_deployment]{cancel_component_deployment} \tab Attempts to cancel a component deployment (for a component that is in the IN_PROGRESS deployment status)\cr
\link[paws.compute:proton_cancel_environment_deployment]{cancel_environment_deployment} \tab Attempts to cancel an environment deployment on an UpdateEnvironment action, if the deployment is IN_PROGRESS\cr
\link[paws.compute:proton_cancel_service_instance_deployment]{cancel_service_instance_deployment} \tab Attempts to cancel a service instance deployment on an UpdateServiceInstance action, if the deployment is IN_PROGRESS\cr
\link[paws.compute:proton_cancel_service_pipeline_deployment]{cancel_service_pipeline_deployment} \tab Attempts to cancel a service pipeline deployment on an UpdateServicePipeline action, if the deployment is IN_PROGRESS\cr
\link[paws.compute:proton_create_component]{create_component} \tab Create an Proton component\cr
\link[paws.compute:proton_create_environment]{create_environment} \tab Deploy a new environment\cr
\link[paws.compute:proton_create_environment_account_connection]{create_environment_account_connection} \tab Create an environment account connection in an environment account so that environment infrastructure resources can be provisioned in the environment account from a management account\cr
\link[paws.compute:proton_create_environment_template]{create_environment_template} \tab Create an environment template for Proton\cr
\link[paws.compute:proton_create_environment_template_version]{create_environment_template_version} \tab Create a new major or minor version of an environment template\cr
\link[paws.compute:proton_create_repository]{create_repository} \tab Create and register a link to a repository\cr
\link[paws.compute:proton_create_service]{create_service} \tab Create an Proton service\cr
\link[paws.compute:proton_create_service_instance]{create_service_instance} \tab Create a service instance\cr
\link[paws.compute:proton_create_service_sync_config]{create_service_sync_config} \tab Create the Proton Ops configuration file\cr
\link[paws.compute:proton_create_service_template]{create_service_template} \tab Create a service template\cr
\link[paws.compute:proton_create_service_template_version]{create_service_template_version} \tab Create a new major or minor version of a service template\cr
\link[paws.compute:proton_create_template_sync_config]{create_template_sync_config} \tab Set up a template to create new template versions automatically by tracking a linked repository\cr
\link[paws.compute:proton_delete_component]{delete_component} \tab Delete an Proton component resource\cr
\link[paws.compute:proton_delete_environment]{delete_environment} \tab Delete an environment\cr
\link[paws.compute:proton_delete_environment_account_connection]{delete_environment_account_connection} \tab In an environment account, delete an environment account connection\cr
\link[paws.compute:proton_delete_environment_template]{delete_environment_template} \tab If no other major or minor versions of an environment template exist, delete the environment template\cr
\link[paws.compute:proton_delete_environment_template_version]{delete_environment_template_version} \tab If no other minor versions of an environment template exist, delete a major version of the environment template if it's not the Recommended version\cr
\link[paws.compute:proton_delete_repository]{delete_repository} \tab De-register and unlink your repository\cr
\link[paws.compute:proton_delete_service]{delete_service} \tab Delete a service, with its instances and pipeline\cr
\link[paws.compute:proton_delete_service_sync_config]{delete_service_sync_config} \tab Delete the Proton Ops file\cr
\link[paws.compute:proton_delete_service_template]{delete_service_template} \tab If no other major or minor versions of the service template exist, delete the service template\cr
\link[paws.compute:proton_delete_service_template_version]{delete_service_template_version} \tab If no other minor versions of a service template exist, delete a major version of the service template if it's not the Recommended version\cr
\link[paws.compute:proton_delete_template_sync_config]{delete_template_sync_config} \tab Delete a template sync configuration\cr
\link[paws.compute:proton_get_account_settings]{get_account_settings} \tab Get detail data for Proton account-wide settings\cr
\link[paws.compute:proton_get_component]{get_component} \tab Get detailed data for a component\cr
\link[paws.compute:proton_get_environment]{get_environment} \tab Get detailed data for an environment\cr
\link[paws.compute:proton_get_environment_account_connection]{get_environment_account_connection} \tab In an environment account, get the detailed data for an environment account connection\cr
\link[paws.compute:proton_get_environment_template]{get_environment_template} \tab Get detailed data for an environment template\cr
\link[paws.compute:proton_get_environment_template_version]{get_environment_template_version} \tab Get detailed data for a major or minor version of an environment template\cr
\link[paws.compute:proton_get_repository]{get_repository} \tab Get detail data for a linked repository\cr
\link[paws.compute:proton_get_repository_sync_status]{get_repository_sync_status} \tab Get the sync status of a repository used for Proton template sync\cr
\link[paws.compute:proton_get_resources_summary]{get_resources_summary} \tab Get counts of Proton resources\cr
\link[paws.compute:proton_get_service]{get_service} \tab Get detailed data for a service\cr
\link[paws.compute:proton_get_service_instance]{get_service_instance} \tab Get detailed data for a service instance\cr
\link[paws.compute:proton_get_service_instance_sync_status]{get_service_instance_sync_status} \tab Get the status of the synced service instance\cr
\link[paws.compute:proton_get_service_sync_blocker_summary]{get_service_sync_blocker_summary} \tab Get detailed data for the service sync blocker summary\cr
\link[paws.compute:proton_get_service_sync_config]{get_service_sync_config} \tab Get detailed information for the service sync configuration\cr
\link[paws.compute:proton_get_service_template]{get_service_template} \tab Get detailed data for a service template\cr
\link[paws.compute:proton_get_service_template_version]{get_service_template_version} \tab Get detailed data for a major or minor version of a service template\cr
\link[paws.compute:proton_get_template_sync_config]{get_template_sync_config} \tab Get detail data for a template sync configuration\cr
\link[paws.compute:proton_get_template_sync_status]{get_template_sync_status} \tab Get the status of a template sync\cr
\link[paws.compute:proton_list_component_outputs]{list_component_outputs} \tab Get a list of component Infrastructure as Code (IaC) outputs\cr
\link[paws.compute:proton_list_component_provisioned_resources]{list_component_provisioned_resources} \tab List provisioned resources for a component with details\cr
\link[paws.compute:proton_list_components]{list_components} \tab List components with summary data\cr
\link[paws.compute:proton_list_environment_account_connections]{list_environment_account_connections} \tab View a list of environment account connections\cr
\link[paws.compute:proton_list_environment_outputs]{list_environment_outputs} \tab List the infrastructure as code outputs for your environment\cr
\link[paws.compute:proton_list_environment_provisioned_resources]{list_environment_provisioned_resources} \tab List the provisioned resources for your environment\cr
\link[paws.compute:proton_list_environments]{list_environments} \tab List environments with detail data summaries\cr
\link[paws.compute:proton_list_environment_templates]{list_environment_templates} \tab List environment templates\cr
\link[paws.compute:proton_list_environment_template_versions]{list_environment_template_versions} \tab List major or minor versions of an environment template with detail data\cr
\link[paws.compute:proton_list_repositories]{list_repositories} \tab List linked repositories with detail data\cr
\link[paws.compute:proton_list_repository_sync_definitions]{list_repository_sync_definitions} \tab List repository sync definitions with detail data\cr
\link[paws.compute:proton_list_service_instance_outputs]{list_service_instance_outputs} \tab Get a list service of instance Infrastructure as Code (IaC) outputs\cr
\link[paws.compute:proton_list_service_instance_provisioned_resources]{list_service_instance_provisioned_resources} \tab List provisioned resources for a service instance with details\cr
\link[paws.compute:proton_list_service_instances]{list_service_instances} \tab List service instances with summary data\cr
\link[paws.compute:proton_list_service_pipeline_outputs]{list_service_pipeline_outputs} \tab Get a list of service pipeline Infrastructure as Code (IaC) outputs\cr
\link[paws.compute:proton_list_service_pipeline_provisioned_resources]{list_service_pipeline_provisioned_resources} \tab List provisioned resources for a service and pipeline with details\cr
\link[paws.compute:proton_list_services]{list_services} \tab List services with summaries of detail data\cr
\link[paws.compute:proton_list_service_templates]{list_service_templates} \tab List service templates with detail data\cr
\link[paws.compute:proton_list_service_template_versions]{list_service_template_versions} \tab List major or minor versions of a service template with detail data\cr
\link[paws.compute:proton_list_tags_for_resource]{list_tags_for_resource} \tab List tags for a resource\cr
\link[paws.compute:proton_notify_resource_deployment_status_change]{notify_resource_deployment_status_change} \tab Notify Proton of status changes to a provisioned resource when you use self-managed provisioning\cr
\link[paws.compute:proton_reject_environment_account_connection]{reject_environment_account_connection} \tab In a management account, reject an environment account connection from another environment account\cr
\link[paws.compute:proton_tag_resource]{tag_resource} \tab Tag a resource\cr
\link[paws.compute:proton_untag_resource]{untag_resource} \tab Remove a customer tag from a resource\cr
\link[paws.compute:proton_update_account_settings]{update_account_settings} \tab Update Proton settings that are used for multiple services in the Amazon Web Services account\cr
\link[paws.compute:proton_update_component]{update_component} \tab Update a component\cr
\link[paws.compute:proton_update_environment]{update_environment} \tab Update an environment\cr
\link[paws.compute:proton_update_environment_account_connection]{update_environment_account_connection} \tab In an environment account, update an environment account connection to use a new IAM role\cr
\link[paws.compute:proton_update_environment_template]{update_environment_template} \tab Update an environment template\cr
\link[paws.compute:proton_update_environment_template_version]{update_environment_template_version} \tab Update a major or minor version of an environment template\cr
\link[paws.compute:proton_update_service]{update_service} \tab Edit a service description or use a spec to add and delete service instances\cr
\link[paws.compute:proton_update_service_instance]{update_service_instance} \tab Update a service instance\cr
\link[paws.compute:proton_update_service_pipeline]{update_service_pipeline} \tab Update the service pipeline\cr
\link[paws.compute:proton_update_service_sync_blocker]{update_service_sync_blocker} \tab Update the service sync blocker by resolving it\cr
\link[paws.compute:proton_update_service_sync_config]{update_service_sync_config} \tab Update the Proton Ops config file\cr
\link[paws.compute:proton_update_service_template]{update_service_template} \tab Update a service template\cr
\link[paws.compute:proton_update_service_template_version]{update_service_template_version} \tab Update a major or minor version of a service template\cr
\link[paws.compute:proton_update_template_sync_config]{update_template_sync_config} \tab Update template sync configuration parameters, except for the templateName and templateType
}
}

\examples{
\dontrun{
svc <- proton()
svc$accept_environment_account_connection(
  Foo = 123
)
}

}
