% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{batch}
\alias{batch}
\title{AWS Batch}
\usage{
batch(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
Using AWS Batch, you can run batch computing workloads on the AWS Cloud.
Batch computing is a common means for developers, scientists, and
engineers to access large amounts of compute resources. AWS Batch
utilizes the advantages of this computing workload to remove the
undifferentiated heavy lifting of configuring and managing required
infrastructure, while also adopting a familiar batch computing software
approach. Given these advantages, AWS Batch can help you to efficiently
provision resources in response to jobs submitted, thus effectively
helping to eliminate capacity constraints, reduce compute costs, and
deliver your results more quickly.

As a fully managed service, AWS Batch can run batch computing workloads
of any scale. AWS Batch automatically provisions compute resources and
optimizes workload distribution based on the quantity and scale of your
specific workloads. With AWS Batch, there's no need to install or manage
batch computing software. This means that you can focus your time and
energy on analyzing results and solving your specific problems.
}
\section{Service syntax}{
\preformatted{svc <- batch(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=batch_cancel_job]{cancel_job} \tab Cancels a job in an AWS Batch job queue\cr
\link[=batch_create_compute_environment]{create_compute_environment} \tab Creates an AWS Batch compute environment\cr
\link[=batch_create_job_queue]{create_job_queue} \tab Creates an AWS Batch job queue\cr
\link[=batch_delete_compute_environment]{delete_compute_environment} \tab Deletes an AWS Batch compute environment\cr
\link[=batch_delete_job_queue]{delete_job_queue} \tab Deletes the specified job queue\cr
\link[=batch_deregister_job_definition]{deregister_job_definition} \tab Deregisters an AWS Batch job definition\cr
\link[=batch_describe_compute_environments]{describe_compute_environments} \tab Describes one or more of your compute environments\cr
\link[=batch_describe_job_definitions]{describe_job_definitions} \tab Describes a list of job definitions\cr
\link[=batch_describe_job_queues]{describe_job_queues} \tab Describes one or more of your job queues\cr
\link[=batch_describe_jobs]{describe_jobs} \tab Describes a list of AWS Batch jobs\cr
\link[=batch_list_jobs]{list_jobs} \tab Returns a list of AWS Batch jobs\cr
\link[=batch_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags for an AWS Batch resource\cr
\link[=batch_register_job_definition]{register_job_definition} \tab Registers an AWS Batch job definition\cr
\link[=batch_submit_job]{submit_job} \tab Submits an AWS Batch job from a job definition\cr
\link[=batch_tag_resource]{tag_resource} \tab Associates the specified tags to a resource with the specified resourceArn\cr
\link[=batch_terminate_job]{terminate_job} \tab Terminates a job in a job queue\cr
\link[=batch_untag_resource]{untag_resource} \tab Deletes specified tags from an AWS Batch resource\cr
\link[=batch_update_compute_environment]{update_compute_environment} \tab Updates an AWS Batch compute environment\cr
\link[=batch_update_job_queue]{update_job_queue} \tab Updates a job queue
}
}

\examples{
\dontrun{
svc <- batch()
# This example cancels a job with the specified job ID.
svc$cancel_job(
  jobId = "1d828f65-7a4d-42e8-996d-3b900ed59dc4",
  reason = "Cancelling job."
)
}

}
